%def_disable static
%define ver_major 0.8

Name: libIDL
Version: %ver_major.14
Release: alt3

Summary: Library for parsing IDL (Interface Definition Language)
Group: System/Libraries
License: %lgpl2plus
Url: ftp://ftp.gnome.org

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

%define pkgconfig_ver 0.15-alt3.2
%define glib_ver 2.4.0

BuildPreReq: rpm-build-licenses rpm-build-gnome
BuildPreReq: pkgconfig >= %pkgconfig_ver
BuildPreReq: glib2-devel >= %glib_ver

BuildRequires: gnome-common flex

%description
libIDL is a library for parsing IDL (Interface Definition Language).
It can be used for both COM-style and CORBA-style IDL.

%package devel
Summary: Development libraries and header files for libIDL
Group: Development/C
Requires: %name = %version-%release

%description devel
libIDL is a library for parsing IDL (Interface Definition Language).
It can be used for both COM-style and CORBA-style IDL.

This package contains the header files and libraries needed to write
or compile programs that use libIDL.

%package devel-doc
Summary: Development documentation for libIDL
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
libIDL is a library for parsing IDL (Interface Definition Language).
It can be used for both COM-style and CORBA-style IDL.

This package contains the documentation needed to develop programs that
use libIDL.

%if_enabled static
%package devel-static
Summary: Static libraries for libIDL
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
libIDL is a library for parsing IDL (Interface Definition Language).
It can be used for both COM-style and CORBA-style IDL.

This package contains static libraries needed to compile statically
linked programs that use %name.
%endif

%prep
%setup -q

%build
%configure \
    %{subst_enable static}

%make_build

%install
%makeinstall

mkdir %buildroot%_datadir/idl

%files
%_libdir/*.so.*
%doc AUTHORS README NEWS

%files devel
%_bindir/*
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%dir %_datadir/idl
%doc BUGS HACKING MAINTAINERS

%files devel-doc
%_infodir/%{name}*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
