%def_enable minimal

Name: libaal
Version: 1.0.5
Release: alt3.1.qa1

Packager: Victor Forsiuk <force@altlinux.org>

Summary: Abstraction library for ReiserFS utilities
License: GPLv2
Group: System/Kernel and hardware

URL: http://www.kernel.org/pub/linux/utils/fs/reiser4/
Source0: http://www.kernel.org/pub/linux/utils/fs/reiser4/libaal/libaal-%version.tar.bz2

# c++ not needed for compilation but configure insist on its presence :)
# Automatically added by buildreq on Tue Mar 16 2010
BuildRequires: gcc-c++

%description
This is a library that provides application abstraction mechanism.
It include device abstraction, libc independence code, etc.

%package devel
Summary: Headers and static libraries for developing with libaal.
Group: Development/C
Requires: libaal = %version-%release

%description devel
This package includes the headers and static libraries for developing
with the libaal library.

%if_enabled minimal
%package minimal
Summary: Minimal abstraction library for ReiserFS utilities
Group: System/Kernel and hardware

%description minimal
This is a minimal library that provides application abstraction mechanism.
It include device abstraction, libc independence code, etc.

%package minimal-devel
Summary: Headers and static libraries for developing with libaal.
Group: Development/C
Requires: libaal-minimal = %version-%release libaal-devel = %version-%release

%description minimal-devel
This package includes the headers and static libraries for developing
with the minimal libaal library.
%endif

%prep
%setup

%build
%configure --libdir=/%_lib \
%if_enabled minimal
	--enable-libminimal
%else
	--disable-libminimal --disable-memory-manager
%endif

%make_build

%install
%makeinstall_std

# Static libraries and library symlinks not needed to be in %_lib/
# Relocate them to %_libdir/.
install -d %buildroot%_libdir
for f in %buildroot/%_lib/*.so; do
        v="$(readlink -n "$f")"
        ln -sf ../../%_lib/"$v" "$f"
done
mv %buildroot/%_lib/*.a %buildroot%_libdir/
mv %buildroot/%_lib/*.so %buildroot%_libdir/

%files
# COPYING contains information other than GPL text, so it should be packaged
%doc COPYING
/%_lib/libaal-1.0.so*

%files devel
%_libdir/libaal.so*
%_libdir/libaal.*a
%_includedir/aal
%_datadir/aclocal/libaal.m4

%if_enabled minimal
%files minimal
/%_lib/libaal-minimal.so.*

%files minimal-devel
%_libdir/libaal-minimal.so
%_libdir/libaal-minimal.*a
%endif

%changelog
