%define oname afflib

Name: libaff
Version: 3.6.8
Release: alt1.M70T.1

Summary: A set of programs for creating and manipulating AFF files

Group: System/Libraries
License: BSD
# afflib.org unavailable, refs dropped by recent commits
Url: http://digitalcorpora.org/downloads/afflib/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://www.afflib.org/downloads/%oname-%version.tar
Patch0: afflib-shared.diff
Patch1: afflib-no_win32.diff
Patch2: %name-fix-build.patch

# Automatically added by buildreq on Wed Mar 30 2011
BuildRequires: gcc-c++ glibc-devel libcurl-devel libexpat-devel libfuse-devel libncurses-devel libreadline-devel libssl-devel zlib-devel

%description
AFFLIB is an open source library developed by Simson Garfinkel and Basis
Technology that implements the AFF standard. AFFLIB is distributed under
4-clause Berkeley License and may be freely incorporated into both Open
Source and Proprietary software.

In addition to the library, AFFLIB also comes with the AFF Tools, a set of
programs for creating and manipulating AFF files.

%package devel
Summary: Header files for the afflib library
Group: Development/C
Requires: %name = %version-%release

%description devel
AFFLIB is an open source library developed by Simson Garfinkel and Basis
Technology that implements the AFF standard. AFFLIB is distributed under
4-clause Berkeley License and may be freely incorporated into both Open
Source and Proprietary software.

This package contains the header files.

%package -n aff-tools
Summary: AFFLIB tools
Group: File tools
Requires: %name = %version-%release

%description -n aff-tools
AFFLIB is an open source library developed by Simson Garfinkel and Basis
Technology that implements the AFF standard. AFFLIB is distributed under
4-clause Berkeley License and may be freely incorporated into both Open
Source and Proprietary software.

This package contains AFF Tools.

%prep
%setup -n %oname-%version
#%patch0 -p1
#%patch1 -p0
#%patch2

%build
%__subst "s|-static.*||g" tools/Makefile.am lib/Makefile.am
mkdir -p m4
%autoreconf

%configure \
    --enable-libewf=yes \
    --enable-s3=yes \
    --enable-fuse=yes \
    --with-curl=%prefix \
    --enable-qemu=no \
    --disable-static

%make_build

%install
%makeinstall_std

# install headers as well
#install -d %buildroot%_includedir/afflib
#install -m0644 lib/*.h %buildroot%_includedir/afflib/

%files
%_libdir/*.so.*

%files -n aff-tools
%_bindir/affcat
%_bindir/affcompare
%_bindir/affcrypto
%_bindir/affrecover
%_bindir/affsign
%_bindir/affverify
%_bindir/affconvert
%_bindir/affcopy
%_bindir/affix
%_bindir/affuse
%_bindir/affinfo
%_bindir/affsegment
%_bindir/affstats
%_bindir/affxml
%_bindir/affdiskprint
%_man1dir/*
%doc AUTHORS BUGLIST.txt COPYING ChangeLog NEWS README* doc/*
%_libdir/*.so.*

%files devel
%dir %_includedir/afflib/
%_includedir/afflib/*.h
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
