Name: libassuan0
Version: 1.0.5
Release: alt5.1.qa1

Summary: IPC library used by some GnuPG related software
License: LGPLv2.1+
Group: System/Libraries
Url: http://gnupg.org/related_software/libraries.html
Packager: Sergey V Turchin <zerg@altlinux.org>

# ftp://ftp.gnupg.org/gcrypt/libassuan/libassuan-%version.tar.bz2
Source0: libassuan-%version.tar
Source1: version-script-assuan-%version.map
Source2: version-script-assuan-pth-%version.map

Patch1: libassuan-1.0.5-alt-texinfo.patch
Patch2: libassuan-1.0.5-alt-warnings.patch
Patch3: libassuan-1.0.1-alt-shared.patch
Patch4: libassuan-1.0.4-alt-linking.patch

BuildRequires: libgpg-error-devel libpth-devel

%def_enable shared
%def_disable static

%package devel
Summary: Development files for the libassuan library
Group: Development/C
%if_enabled shared
Requires: %name = %version-%release
%endif
Conflicts: libassuan-devel

%package devel-static
Summary: Static libassuan library
Group: Development/C
Requires: %name-devel = %version-%release

%description
This is the IPC library used by GnuPG 2, GPGME and a few other packages.

%description devel
This package contains development files for the libassuan library.

%description devel-static
This package contains static libassuan library.

%prep
%setup -n libassuan-%version
install -m 0644 %SOURCE1 src/version-script-assuan.map
install -m 0644 %SOURCE2 src/version-script-assuan-pth.map
%patch1 -p1
%patch2 -p1
%if_enabled shared
%patch3 -p1
%patch4 -p1
%endif

# Rename library: libassuan -> libassuan0.
sed -i 's/libassuan\(.la\)/libassuan0\1/g' */Makefile.am

%build
%autoreconf
%if_disabled shared
%add_optflags %optflags_shared
%endif
%configure \
    %{subst_enable shared} \
    %{subst_enable static}
%make_build

%install
%makeinstall_std
mv %buildroot%_libdir/libassuan{0,}.so

%check
%make_build check

%if_enabled shared
%files
%doc AUTHORS NEWS README THANKS
%_libdir/lib*.so.*
%endif

%files devel
%_bindir/libassuan-config
%if_enabled shared
%_libdir/lib*.so
%else
%doc AUTHORS NEWS README THANKS
%endif
%_includedir/*.h
%_datadir/aclocal/*.m4
%_infodir/*.info*

%if_enabled static
%files devel-static
%_libdir/lib*.a
%endif

%changelog
