Name: libcaca
Version: 0.99
Release: alt13.beta17.1

Summary: Text mode graphics library
Group: System/Libraries
License: DWTFYWTPL
Url: http://sam.zoy.org/projects/libcaca/

# http://caca.zoy.org/files/libcaca/%name-%version.beta17.tar.gz
Source: %name-%version.tar
Patch: libcaca-ruby1.9.patch

%ifarch x86_64
Provides: libcucul.so.0()(64bit)
Provides: libcucul++.so.0()(64bit)
%else
Provides: libcucul.so.0
Provides: libcucul++.so.0
%endif

BuildPreReq: rpm-build-ruby

%def_disable static

# Automatically added by buildreq on Mon Apr 25 2011
# optimized out: imlib2 libX11-devel libstdc++-devel libtinfo-devel pkg-config ruby tex-common texlive-base texlive-base-bin texlive-common texlive-fonts-recommended texlive-latex-base texlive-latex-recommended texmf-latex-xcolor xorg-kbproto-devel xorg-xproto-devel
BuildRequires: doxygen gcc-c++ imake imlib2-devel libncurses-devel libruby-devel libslang2-devel texlive-generic-recommended texlive-publishers texlive-xetex xorg-cf-files

%description
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

%package devel
Summary: Development files for libcaca
Group: Development/C
Requires: %name = %version-%release

%description devel
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

This package contains the header files and static libraries needed to
compile applications or shared objects that use libcaca.

%package -n caca-utils
Summary: Text mode graphics utilities
Group: Graphics
Requires: %name = %version-%release

%description -n caca-utils
This package contains utilities and demonstration programs for libcaca, the
Colour AsCii Art library.

cacaview is a simple image viewer for the terminal. It opens most image
formats such as JPEG, PNG, GIF etc. and renders them on the terminal using
ASCII art. The user can zoom and scroll the image, set the dithering method
or enable anti-aliasing.

cacaball is a tiny graphic program that renders animated ASCII metaballs on
the screen, cacafire is a port of AALib's aafire and displays burning ASCII
art flames, cacamoir animates colourful moire circles and cacaplas displays
an old school plasma effect.

cacademo is a simple application that shows the libcaca rendering features
such as line and ellipses drawing, triangle filling and sprite blitting.

%package -n ruby-libcaca
Summary: Ruby bindings for libcaca
Group: Graphics
Requires: %name = %version-%release
Provides: ruby-module-libcaca = %version-%release
Obsoletes: ruby-module-libcaca

%description -n ruby-libcaca
libcaca is the Colour AsCii Art library. It provides high level functions
for colour text drawing, simple primitives for line, polygon and ellipse
drawing, as well as powerful image to text conversion routines.

This package contains Ruby bindings for libcaca.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--enable-slang \
	--enable-ncurses \
	--enable-x11 \
	--enable-imlib2 \
	--enable-doc \
	--x-libraries=%_x11libdir \
	--disable-debug \
	%{subst_enable static}

%make_build

%install
%makeinstall_std
rm %buildroot%_libdir/*.la
rm -r %buildroot%_man3dir
rm -f %buildroot%_docdir/libcucul-dev
mv %buildroot%_datadir/doc/%name-dev %buildroot%_docdir/%name-%version

%files
%_libdir/*.so.*

%files devel
%_libdir/*.so
%_bindir/caca-config
%_includedir/*
%_docdir/%name-%version
%_man1dir/caca-config.1*
%_pkgconfigdir/*

%files -n caca-utils
%_bindir/cacademo
%_bindir/cacafire
%_bindir/cacaview
%_bindir/cacaplay
%_bindir/cacaserver
%_bindir/img2txt
%_datadir/%name
%_man1dir/cacademo.1*
%_man1dir/cacafire.1*
%_man1dir/cacaview.1*
%_man1dir/cacaplay.1*
%_man1dir/cacaserver.1*
%_man1dir/img2txt.1*

%files -n ruby-libcaca
%ruby_sitelibdir/caca.rb
%ruby_sitearchdir/caca.*

%changelog
