%def_enable tdb
%def_disable oss
%def_enable gtk
%def_enable gtk3

%define ver_major 0.30
%define gtk_api_ver 2.0
%define gtk3_api_ver 3.0
%define gst_api_ver 1.0

Name: libcanberra
Version: %ver_major
Release: alt1

Summary: Portable Sound Event Library
Group: System/Libraries
License: LGPLv2+
Url: http://0pointer.de/lennart/projects/libcanberra

Source: http://0pointer.de/lennart/projects/libcanberra/%name-%version.tar.xz

%define pa_ver 0.9.11
%define gtk_ver 2.20
%define gtk3_ver 3.0.0
%define tdb_ver 1.1

Requires: sound-theme-freedesktop
Requires: libpulseaudio >= %pa_ver

BuildPreReq: libpulseaudio-devel >= %pa_ver
%{?_enable_gtk:BuildPreReq: libgtk+2-devel >= %gtk_ver}
%{?_enable_gtk3:BuildPreReq: libgtk+3-devel >= %gtk3_ver}
BuildRequires: gcc-c++ gstreamer%gst_api_ver-devel gtk-doc libalsa-devel libudev-devel
BuildRequires: libltdl-devel libvorbis-devel vala-tools
%{?_enable_tdb:BuildRequires: libtdb-devel >= %tdb_ver}

%description
A small and lightweight implementation of the XDG Sound Theme Specification
(http://0pointer.de/public/sound-theme-spec.html).

%package gtk2
Summary: Gtk+ Bindings for libcanberra
Group: System/Libraries
Provides: %name-gtk = %version-%release
Requires: %name = %version-%release

%description gtk2
Gtk+ bindings for libcanberra

%package gtk3
Summary: Gtk+3 Bindings for libcanberra
Group: System/Libraries
Provides: %name-gtk = %version-%release
Requires: %name = %version-%release

%description gtk3
Gtk+3 bindings for libcanberra

%package gnome
Summary: GNOME-specific part of libcanberra
Group: Graphical desktop/GNOME
BuildArch: noarch

%description gnome
This package provides some .desktop files needed for GNOME.

%package devel
Summary: Development files for libcanberra
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains files for libcanberra client development

%package gtk-common-devel
Summary: Development files of Gtk+ bindings for libcanberra
Group: Development/C
Requires: %name = %version-%release
Requires: %name-devel = %version-%release

%description gtk-common-devel
This package contains common header for libcanberra-gtk{2,3} client development

%package gtk2-devel
Summary: Development files for libcanberra-gtk2
Group: Development/C
Requires: %name-gtk2 = %version-%release
Requires: %name-devel = %version-%release
Requires: %name-gtk-common-devel = %version-%release

%description gtk2-devel
This package contains files for libcanberra-gtk2 client development

%package gtk3-devel
Summary: Development files for libcanberra-gtk3
Group: Development/C
Requires: %name-gtk3 = %version-%release
Requires: %name-devel = %version-%release
Requires: %name-gtk-common-devel = %version-%release

%description gtk3-devel
This package contains files for libcanberra-gtk3 client development

%package devel-doc
Summary: Development documentation for libcanberra
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package contains development documentation for libcanberra

%package vala
Summary: Vala Bindings for libcanberra
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description vala
This package provides Vala language bindings for libcanberra and
libcanberra-gtk libraries

%prep
%setup -q

%build
%configure --disable-static \
	--enable-pulse \
	--enable-alsa \
	--enable-null \
	%{subst_enable oss} \
	%{subst_enable tdb} \
	--with-builtin=dso \
	--with-systemdsystemunitdir=%systemd_unitdir

%make_build

%check
%make check

%install
%make DESTDIR=%buildroot install
rm -f %buildroot%_docdir/libcanberra/README


%files
%_libdir/libcanberra.so.*
%dir %_libdir/libcanberra-%ver_major
%_libdir/libcanberra-%ver_major/libcanberra-null.so
%_libdir/libcanberra-%ver_major/libcanberra-alsa.so
%_libdir/libcanberra-%ver_major/libcanberra-pulse.so
%_libdir/libcanberra-%ver_major/libcanberra-multi.so
%_libdir/libcanberra-%ver_major/libcanberra-gstreamer.so
%if_enabled oss
%_libdir/libcanberra-%ver_major/libcanberra-oss.so
%endif
# systemd files
%_bindir/canberra-boot
%systemd_unitdir/canberra-system-bootup.service
%systemd_unitdir/canberra-system-shutdown-reboot.service
%systemd_unitdir/canberra-system-shutdown.service

%doc README

%files devel
%_includedir/canberra.h
%_libdir/libcanberra.so
%_libdir/pkgconfig/libcanberra.pc

%files gnome
%_datadir/gnome/autostart/libcanberra-login-sound.desktop
%_datadir/gnome/shutdown/libcanberra-logout-sound.sh
%_datadir/gdm/autostart/LoginWindow/libcanberra-ready-sound.desktop

%files gtk-common-devel
%_includedir/canberra-gtk.h

%if_enabled gtk
%files gtk2
%{?_disable_gtk3:%_bindir/canberra-gtk-play}
%_libdir/libcanberra-gtk.so.*
%_libdir/gtk-%gtk_api_ver/modules/libcanberra-gtk-module.so

%files gtk2-devel
%_libdir/libcanberra-gtk.so
%_libdir/pkgconfig/libcanberra-gtk.pc
%endif

%if_enabled gtk3
%files gtk3
%_bindir/canberra-gtk-play
%_libdir/libcanberra-gtk3.so.*
%_libdir/gtk-%gtk3_api_ver/modules/libcanberra-gtk-module.so
%_libdir/gtk-%gtk3_api_ver/modules/libcanberra-gtk3-module.so
%_libdir/gnome-settings-daemon-3.0/gtk-modules/canberra-gtk-module.desktop

%files gtk3-devel
%_libdir/libcanberra-gtk3.so
%_libdir/pkgconfig/libcanberra-gtk3.pc
%endif

%files vala
%_datadir/vala/vapi/libcanberra-gtk.vapi
%_datadir/vala/vapi/libcanberra.vapi

%files devel-doc
%_datadir/gtk-doc/html/*

%exclude %_libdir/libcanberra-%ver_major/*.la
%{?_enable_gtk:%exclude %_libdir/gtk-%gtk_api_ver/modules/*.la}
%{?_enable_gtk3:%exclude %_libdir/gtk-%gtk3_api_ver/modules/*.la}

%changelog
