%define _name libchamplain
%define ver_major 0.12
%define api_ver 0.12
%def_enable introspection
%def_enable vala
%def_enable gtk_doc

Name: %_name
Version: %ver_major.5
Release: alt1

Summary: Map view library for Clutter
License: LGPLv2+
Group: System/Libraries
Url: http://projects.gnome.org/%name/

Source: http://ftp.gnome.org/pub/GNOME/sources/%name/%ver_major/%_name-%version.tar.xz
#Source: %_name-%version.tar

%define glib_ver 2.16
%define cairo_ver 1.4
%define gtk_ver 3.0.1
%define clutter_ver 1.12
%define soup_ver 2.33.90
%define gir_ver 0.10.3

BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libcairo-devel >= %cairo_ver
BuildPreReq: libclutter-devel >= %clutter_ver
BuildPreReq: libsoup-gnome-devel >= %soup_ver
BuildRequires: libclutter-gtk3-devel libsoup-devel libsqlite3-devel gtk-doc
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.9.5 libgtk+3-gir-devel libclutter-gir-devel}

%description
Libchamplain is a C library aimed to provide a ClutterActor to display
rasterized maps.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files for %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package contains development documentation for %name.

%package gtk3
Summary: Gtk+ widget wrapper for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gtk3
Libchamplain-gtk is a library providing a GtkWidget to embed %name
into Gtk+ applications.

%package gtk3-devel
Summary: Development files for %name-gtk
Group: Development/C
Requires: %name-gtk3 = %version-%release
Requires: %name-devel = %version-%release

%description gtk3-devel
This package contains development files for %name-gtk.

%package gtk3-devel-doc
Summary: Development documentation for %name-gtk
Group: Development/C
BuildArch: noarch
Conflicts: %name-gtk3 < %version

%description gtk3-devel-doc
This package contains development documentation for %name-gtk.

%package gir
Summary: GObject introspection data for the Libchamplain library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Libchamplain library

%package gir-devel
Summary: GObject introspection devel data for the Libchamplain library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the Libchamplain library

%package gtk3-gir
Summary: GObject introspection data for the Libchamplain library
Group: System/Libraries
Requires: %name-gtk3 = %version-%release
Requires: %name-gir = %version-%release

%description gtk3-gir
GObject introspection data for the Libchamplain library

%package gtk3-gir-devel
Summary: GObject introspection devel data for the Libchamplain library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-gtk3-gir = %version-%release
Requires: %name-gir-devel = %version-%release

%description gtk3-gir-devel
GObject introspection devel data for the Libchamplain library

%package vala
Summary: Vala bindings for the Libchamplain library
Group: System/Libraries
BuildArch: noarch
Requires: %name = %version-%release

%description vala
This package provides Vala language bindings for the Libchamplain library


%prep
%setup -q -n %_name-%version

%build
gtkdocize --copy
%autoreconf
%configure --disable-static \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{?_disable_vala:--disable-vala-demos} \
	--enable-introspection=auto

%make_build

%install
%make DESTDIR=%buildroot install

%files
%_libdir/%_name-%api_ver.so.*
%doc AUTHORS ChangeLog NEWS

%files devel
%_libdir/%_name-%api_ver.so
%dir %_includedir/%_name-%api_ver
%_includedir/%_name-%api_ver/champlain
%_libdir/pkgconfig/champlain-%api_ver.pc
%doc demos/animated-marker.c
%doc demos/launcher.c
%doc demos/polygons.c

#%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name-%ver_major
#%endif

%files gtk3
%_libdir/%_name-gtk-%api_ver.so.*

%files gtk3-devel
%_libdir/%_name-gtk-%api_ver.so
%dir %_includedir/%_name-gtk-%api_ver
%_includedir/%_name-gtk-%api_ver/champlain-gtk
%_libdir/pkgconfig/champlain-gtk-%api_ver.pc
%doc demos/launcher-gtk.c
%doc demos/markers.c

#%if_enabled gtk_doc
%files gtk3-devel-doc
%_datadir/gtk-doc/html/%_name-gtk-%ver_major/
#%endif

%if_enabled introspection
%files gir
%_typelibdir/Champlain-%api_ver.typelib

%files gtk3-gir
%_typelibdir/GtkChamplain-%api_ver.typelib

%files gir-devel
%_girdir/Champlain-%api_ver.gir

%files gtk3-gir-devel
%_girdir/GtkChamplain-%api_ver.gir
%endif

%if_enabled vala
%files vala
%_datadir/vala/vapi/*
%endif

%changelog
