Summary: CLAM - C++ Library for Audio and Music
Name: libclam
Version: 1.3.0
Release: alt1.4.qa2
License: GPL
Url: http://clam.iua.upf.edu
Group: System/Libraries
Packager: Timur Batyrshin <erthad@altlinux.org>
Source0: %name-%version.tar.bz2
Patch0: libclam-1.3.0-alt-gcc4.6.patch
Patch1: libclam-1.3.0-alt-glibc-2.16.patch


BuildRequires: doxygen gcc-c++ graphviz id3lib-devel ladspa_sdk libfftw3-devel libmad-devel libsndfile-devel libvorbis-devel libxerces-c28-devel scons texlive-latex-recommended libalsa-devel

BuildPreReq: libjack-devel /proc

%description
CLAM stands for C++ Library for Audio and Music and in Catalan means something
like a "continuous sound produced by a large number of people as to show
approval or disapproval of a given event" It is the best name we could find
after long discussions and it is certainly much better than its original name
(MTG-Classes).

CLAM is a framework to develop audio and music applications in C++.

It provides tools to perform advanced analysis, transformations and synthesis,
visualization for audio and music related objects, and other tools that are
useful to abstract target platform for most tasks in an audio applications
such as audio devices, file formats, threading...

##########################################
##########################################
%package devel
Summary: CLAM - C++ Library for Audio and Music - development files
Group: Development/C++
Requires: %name = %version

%description devel
CLAM is a framework to develop audio and music applications in C++.
It provides tools to perform advanced analysis, transformations and synthesis,
visualization for audio and music related objects, and other tools that are
useful to abstract target platform for most tasks in an audio applications
such as audio devices, file formats, threading...

This package contains the files needed to develop with the following libraries:
clam-core, clam-processing, clam-audioio, clam-vmfl and clam-vmqt.

##########################################
##########################################
%package doc
Summary: Contains the clam-framework documentation and some example programs
Group: Documentation
BuildArch: noarch

%description doc
This package contains the framework documentation and some example programs.

##########################################
##########################################
%prep
%setup 
%patch -p2
%patch1 -p2

%build
install -dm 755 %buildroot%_prefix

[ -n "$NPROCS" ] || NPROCS=1

scons 	-j$NPROCS configure \
	prefix=%buildroot%_prefix \
	release=1 \
	double=0 \
	xmlbackend=xercesc \
	with_ladspa_support=1 \
	with_osc_support=1 \
	with_jack=yes \
	with_jack_support=1 \
	with_fftw=1 \
	with_fftw3=1 \
	with_nr_fft=1 \
	with_sndfile=1 \
	with_oggvorbis=1 \
	with_mad=1 \
	with_id3=1 \
	with_alsa=1 \
	with_portaudio=0 \
	with_portmidi=0 

#scons 	-j$NPROCS
scons 	-j 1

# and now doxygenate CLAM stuff
doxygen ./doxygen.cfg

%install
install -dm 755 %buildroot%_libdir
scons install
mv %buildroot%_prefix/libX/* %buildroot%_libdir

%files
%_libdir/libclam_*.so.*

%files devel
%doc CHANGES INSTALL
%dir %_includedir/CLAM
%_includedir/CLAM/*
%_libdir/libclam_*.so
%_libdir/pkgconfig/*
%_datadir/%name/sconstools/*.py*

%files doc
%doc CHANGES INSTALL
%doc doxygen/*

%changelog
