
Name: libcmis
Version: 0.4.1
Release: alt1.M70P.1
Summary: A C++ client library for the CMIS interface
Group: System/Libraries
License: GPLv2+ or LGPLv2+ or MPLv1.1
Url: http://sourceforge.net/projects/libcmis/
Source: %name-%version.tar

BuildRequires: gcc-c++
BuildRequires: pkgconfig(libcurl)
BuildRequires: pkgconfig(libxml-2.0)

BuildRequires: boost-devel boost-program_options-devel
BuildRequires: doxygen
BuildRequires: xmlto

Patch: %name-%version-%release.patch

%description
LibCMIS is a C++ client library for the CMIS interface. This allows C++
applications to connect to any ECM behaving as a CMIS server like
Alfresco, Nuxeo for the open source ones.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package tools
Summary: Command line tool to access CMIS
Group: Publishing
Requires: %name = %version-%release

%description tools
The %name-tools package contains a tool for accessing CMIS from the
command line.

%prep
%setup
%patch -p1

%build
touch ChangeLog
mkdir -p m4
%autoreconf
%configure --disable-static --disable-werror --disable-tests DOCBOOK2MAN='xmlto man'
%make_build

%install
%make_install install DESTDIR=%buildroot

%files
%doc AUTHORS COPYING.* NEWS README
%_libdir/*.so.*


%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files tools
%_bindir/*
%_man1dir/*.1*

%changelog
