%define oname comedilib
Name: libcomedi
Version: 0.10.0
Release: alt1

Summary: Data Acquisition library for the Comedi DAQ driver
Summary(ru_RU.UTF-8): Библиотека получения данных для драйвера Comedi DAQ.

License: LGPL
Group: Development/Other
Url: http://www.comedi.org

Packager: Vitaly Lipatov <lav@altlinux.ru>
AutoReq: noshell

Source: http://www.comedi.org/download/%oname-%version.tar.bz2
Source1: http://www.comedi.org/download/comedi_examples.tar.gz
Patch: %name-as-needed.patch

# manually removed: hostinfo eric gcc-g77
# Automatically added by buildreq on Sun Nov 07 2004
BuildRequires: docbook-utils-print xmlto dblatex flex gcc-c++ libstdc++-devel python-devel python-modules-encodings swig

%description
The Linux Control and Measurement Device Interface Library.
Comedilib is the library for the Comedi data acquisition driver
for Linux.  It allows Linux processes to acquire data from
supported DAQ cards, such as those from National Instruments.

%description -l ru_RU.UTF-8
Comedilib -- это библиотека для драйвера получения данных Comedi под Linux.
Она позволяет пользовательским процессам получать данные от поддерживаемых
карт DAQ, например, производимых National Instruments.

%package devel
Summary: The files needed for %name application development
Summary(ru_RU.UTF-8): Файлы, требующиеся для разработки приложений с использованием %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains the necessary include files
for developing applications with %name

%description devel -l ru_RU.UTF-8
Пакет %name-devel содержит необходимые заголовочные файлы
для разработки приложений, которые используют %name.

%package -n python-module-comedi
Summary: Python interface for %name
Group: Development/Python
Requires: %name = %version-%release
Provides: %name-python
Obsoletes: %name-python
%setup_python_module comedi

%description -n python-module-comedi
Python interface for %name

%package devel-static
Summary: Static library for %name application development
Summary(ru_RU.UTF-8): Статическая библиотека для разработки приложений с использованием %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
The %name-devel-static package contains the static library
for developing applications with %name
%description devel-static -l ru_RU.UTF-8
Пакет %name-devel-static содержит статическую библиотеку
для разработки приложений, которые используют %name.

%prep
%setup -q -n comedilib-%version
%patch
# unpack examples
#tar xfz %SOURCE1
#__subst 's|comedi_data_read_n|comedi_data_read_n_obsolete|' ./comedi_examples/monitor/sv.c
#__subst 's|demo doc|demo|' Makefile.in

%build
%autoreconf
%configure --localstatedir=%buildroot%_localstatedir --disable-ruby-binding
%make_build
#cd comedi_examples/monitor
#	make
#cd -

%install
%makeinstall_std
#install -d %buildroot%_datadir/%name/examples
#install -s -D -m 755 comedi_examples/monitor/monitor %buildroot%_bindir/comedi_monitor
#mv %buildroot%_datadir/comedilib %buildroot%_datadir/%name

#cd comedi_examples
#cp --target-directory %buildroot%_datadir/%name/examples/$i * -R
#cd -
#install -d %buildroot%_datadir/%name/demo/perl
#cd demo
#cp --target-directory %buildroot%_datadir/%name/demo/$i $(ls | grep -v \\.o) -R
#cd -

%files
%doc AUTHORS README ChangeLog NEWS doc/FAQ
%_libdir/%name.so.*
%_sbindir/comedi_config
#exclude %_bindir/%{name}_monitor
%_bindir/comedi_board_info
%_bindir/comedi_test
#_sysconfdir/hotplug/usb/*
%dir %_sysconfdir/pcmcia
%config(noreplace) %_sysconfdir/pcmcia/*
#_sysconfdir/pcmcia/*
%_man1dir/*
%_man7dir/*
%_man8dir/*

%files -n python-module-comedi
%python_sitelibdir/*.so
%python_sitelibdir/comedi.py*

%files devel
%doc demo
#_bindir/comedi_monitor
%_includedir/comedi*
%_libdir/%name.so
%_docdir/%oname/
%_man3dir/*
%_pkgconfigdir/*

%files devel-static
%_libdir/%name.a

%changelog
