%def_disable static

Name: libcommoncpp2
Version: 1.8.1
Release: alt3.1

%define docdir %_docdir/%name-%version

Summary: "Common C++ v2" - A GNU package for creating portable C++ programs

License: GPL
Group: Development/C++
Url: http://cplusplus.sourceforge.net/

Source: %name-%version-%release.tar
Patch: libcommoncpp2-1.8.1-alt-no-overflow.patch

BuildRequires: gcc-c++ libstdc++-devel zlib-devel libxml2-devel doxygen
BuildRequires: info

%description
Common C++ is a GNU package which offers portable "abstraction" of system
services such as threads, networks, and sockets.  Common C++ also offers
individual frameworks generally useful to developing portable C++
applications including a object persistance engine, math libraries,
threading, sockets, etc.  Common C++ is small, and highly portable.
Common C++ will support most Unix operating systems as well
as Win32, in addition to GNU/Linux.

%package devel
Summary: Common C++ devel files
Group: Development/C
Requires: %name = %version-%release
Requires: libstdc++-devel zlib-devel libxml2-devel gcc-c++

%package devel-static
Summary: Static libraries for %name
Group: Development/C
Requires: %name-devel = %version-%release

%package doc
Summary: Documentation for %name
Group: Development/C

%description devel
Common C++ devel files

%description devel-static
Common C++ devel static files

%description doc
Documentation for %name

%prep
%setup
%patch -p1

%build
%autoreconf
%configure %{subst_enable static}
# SMP-b0rken
make

%install
%make_install install DESTDIR=%buildroot
mkdir -p %buildroot%docdir
cp -a AUTHORS NEWS README THANKS TODO doc/html %buildroot%docdir

%files
%dir %docdir
%docdir/[A-Z]*
%_libdir/*.so.*

%files devel
%_bindir/*
%_libdir/*.so
%_datadir/aclocal/*
%_includedir/*
%_pkgconfigdir/*

%if_enabled statc
%files devel-static
%_libdir/*.a
%endif

%files doc
%docdir/html
%_infodir/commoncpp2.*

%changelog
