# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/guile /usr/bin/guile-config /usr/bin/indent guile18-devel libnlopt-devel libreadline-devel
# END SourceDeps(oneline)
BuildRequires: chrpath
%add_optflags %optflags_shared
Name:           libctl
Version:        3.2.1
Release:        alt1_1
Summary:        Guile-based support for flexible control files

Group:          System/Libraries
# integrator.c and cintergrator.c contain code licensed under GPLv2+
# The rest of the code is LGPLv2+, but most restrictive license wins
# for the package.
License:        GPLv2+
URL:            http://ab-initio.mit.edu/wiki/index.php/Libctl
Source0:        http://ab-initio.mit.edu/libctl/libctl-%{version}.tar.gz
BuildRequires:  gcc-fortran guile-devel
Requires:       guile
Source44: import.info

%description
The libctl package is a Guile-based library that provides support for
flexible control files in scientific simulations.

%package devel
Summary:        Development files for libctl
Group:          Development/C
Requires:       %{name} = %{version}-%{release}

%description devel
This package contains the development files for libctl.

%prep
%setup -q

%build
%configure F77=gfortran --enable-shared --disable-static \
  --includedir=%{_includedir}/ctl LDFLAGS='%{optflags} -lm'
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}
rm -f %{buildroot}%{_libdir}/*.la
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111`; do
	chrpath -d $i ||:
done

%files
%doc COPYING AUTHORS NEWS 
%{_libdir}/*.so.*

%files devel
%doc ChangeLog
%{_bindir}/gen-ctl-io
%{_includedir}/ctl
%{_libdir}/*.so
%{_mandir}/man1/*
%{_datadir}/libctl

%changelog
