%def_enable shared
%def_enable static

%define Name Exempi
%define _name exempi

Name: lib%_name
Version: 2.2.0
Release: alt1

Summary: Library for easy parsing of XMP metadata
Group: System/Libraries
License: %bsd

URL: http://libopenraw.freedesktop.org/wiki/%Name

Source: http://libopenraw.freedesktop.org/download/%_name-%version.tar.bz2

BuildRequires(pre): rpm-build-licenses
BuildRequires: boost-test-devel gcc-c++ libexpat-devel zlib-devel

%description
%Name provides a library for easy parsing of XMP metadata. It is a
port of Adobe XMP SDK to work on UNIX.


%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C
Requires: %name%{?_disable_shared:-devel-static} = %version-%release

%description devel
This package contains the libraries and header files needed for
developing with %name.


%if_enabled static
%package devel-static
Summary: Static library for developing programs that will use %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains the static library needed for developing with
%name.
%endif


%prep
%setup -n %_name-%version

%build
%define _optlevel 3
%autoreconf
%configure \
    %{subst_enable shared} \
    %{subst_enable static}

%make_build

%install
%make_install DESTDIR=%buildroot install

%if_enabled shared
%files
%_bindir/%_name
%doc AUTHORS ChangeLog NEWS README
%_libdir/*.so.*
%endif

%files devel
%{?_disable_shared:%doc AUTHORS ChangeLog NEWS README}
%_includedir/%_name-2.0/
%{?_enable_shared:%_libdir/*.so}
%_pkgconfigdir/*


%if_enabled static
%files devel-static
%_libdir/*.a
%endif


%changelog
