# original spec by ldv@

%define mpiimpl openmpi
%define mpidir %_libdir/openmpi

Name: libfftw3-mpi
Version: 3.3.3
Release: alt1
Epoch: 1

Summary: Library for computing Fast Fourier Transforms (with MPI support)
License: GPLv2+
Group: System/Libraries
Url: http://www.fftw.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# ftp://ftp.fftw.org/pub/fftw/fftw-%version.tar.gz
Source: fftw-%version.tar

BuildPreReq: gcc-fortran ghostscript-classic glibc-devel ocaml
BuildPreReq: libgfortran-devel
BuildPreReq: %mpiimpl-devel

%description
FFTW is a free collection of fast C routines for computing the Discrete
Fourier Transform in one or more dimensions.  It includes complex, real,
symmetric, and parallel transforms, and can handle arbitrary array sizes
efficiently.  FFTW is typically faster than other publically-available
FFT implementations, and is even competitive with vendor-tuned libraries.
To achieve this performance, FFTW uses novel code-generation and runtime
self-optimization techniques (along with many other tricks).

This package contains shared libraries, double and long-double
precision, with MPI support.

%package devel
Summary: Development files for parallel FFTW
Group: Development/Other
Requires: %name = %epoch:%version-%release
Conflicts: libfftw3-devel

%description devel
FFTW is a free collection of fast C routines for computing the Discrete
Fourier Transform in one or more dimensions.  It includes complex, real,
symmetric, and parallel transforms, and can handle arbitrary array sizes
efficiently.  FFTW is typically faster than other publically-available
FFT implementations, and is even competitive with vendor-tuned libraries.
To achieve this performance, FFTW uses novel code-generation and runtime
self-optimization techniques (along with many other tricks).

This package contains development files for FFTW, double and long-double
precision, with MPI support.

%package devel-doc
Summary: Development documentation for parallel FFTW
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
FFTW is a free collection of fast C routines for computing the Discrete
Fourier Transform in one or more dimensions.  It includes complex, real,
symmetric, and parallel transforms, and can handle arbitrary array sizes
efficiently.  FFTW is typically faster than other publically-available
FFT implementations, and is even competitive with vendor-tuned libraries.
To achieve this performance, FFTW uses novel code-generation and runtime
self-optimization techniques (along with many other tricks).

This package contains development documentation for FFTW.

%prep
%setup
mkdir double long-double

%build
mpi-selector --set %mpiimpl
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath=%mpidir/lib -L%mpidir/lib"
export MPIDIR=%mpidir
%add_optflags %optflags_shared
%autoreconf

function buildIt() {
	ln -s ../configure .
	%configure $1 \
		--enable-portable-binary \
		--enable-shared \
		--disable-static \
		--enable-fma \
		--enable-mpi \
		--enable-threads \
		--with-g77-wrappers
	sed -i 's|^\(STRIP\).*|\1=echo|' libtool
	sed -i 's|^\(old_striplib\).*|\1=echo|' libtool
	sed -i 's|^\(striplib\).*|\1=echo|' libtool
	%make
}

pushd double
#cp ../mpi ./ -fR
buildIt
popd

pushd long-double
buildIt --enable-long-double
popd

%install
for i in double long-double; do
	%makeinstall includedir=%buildroot%_includedir/fftw3-mpi -C $i
done

sed -i 's|lfftw3|lfftw3_mpi|' %buildroot%_pkgconfigdir/fftw3.pc
sed -i 's|lfftw3l|lfftw3l_mpi|' %buildroot%_pkgconfigdir/fftw3l.pc
sed -i 's|^\(includedir\).*|\1=%_includedir/fftw3-mpi|' \
	%buildroot%_pkgconfigdir/fftw3.pc \
	%buildroot%_pkgconfigdir/fftw3l.pc

%files
%_libdir/*.so.*

%files devel
%_bindir/*
%_includedir/fftw3-mpi
%_libdir/*.so
%_pkgconfigdir/*
%_infodir/*
%_man1dir/*

%files devel-doc
%doc doc/html doc/*.pdf

%changelog
