%define oname libfltk
%define major 1.3

Name: %{oname}13
Version: %major.0.r9812
Release: alt1

Summary: Multiplatform C++ GUI Fast Light ToolKit
License: LGPL
Group: System/Libraries
URL: http://www.fltk.org/

# http://svn.easysw.com/public/fltk/fltk/branches/branch-1.3/
Source: %name-%version.tar
Source1: CMakeCache.txt

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# Automatically added by buildreq on Mon May 12 2008
BuildRequires: gcc-c++ groff-base libICE-devel libXext-devel
BuildRequires: libXft-devel libalsa-devel libjpeg-devel libGL-devel
BuildRequires: libpng-devel xprop libX11-devel fontconfig-devel
BuildPreReq: libfreetype-devel libGLU-devel libcairo-devel
BuildPreReq: libopensm-devel libXtst-devel libXcomposite-devel
BuildPreReq: libXcursor-devel libXdamage-devel libXdmcp-devel
BuildPreReq: libXfixes-devel libXi-devel libXinerama-devel
BuildPreReq: libXpm-devel libXrandr-devel libXt-devel libXv-devel
BuildPreReq: libXxf86misc-devel libXScrnSaver-devel
BuildPreReq: doxygen cmake glib2-devel libpixman-devel
BuildPreReq: pkgconfig(glproto) pkgconfig(dri2proto)
BuildPreReq: libXxf86vm-devel

%description
The Fast Light ToolKit ("FLTK", pronounced "fulltick") is a LGPL'd
C++ graphical user interface toolkit for X (UNIX(r)), OpenGL(r),
and Microsoft(r) Windows(r) NT 4.0, 95, or 98. It was originally
developed by Mr. Bill Spitzak and is currently maintained by a
small group of developers across the world with a central
repository in the US.

%package -n %oname-devel
Summary: Development environment for multiplatform C++ GUI Fast Light ToolKit
Group: Development/C
Requires: %name = %version-%release

%description -n %oname-devel
The Fast Light ToolKit ("FLTK", pronounced "fulltick") is a LGPL'd
C++ graphical user interface toolkit for X (UNIX(r)), OpenGL(r),
and Microsoft(r) Windows(r) NT 4.0, 95, or 98. It was originally
developed by Mr. Bill Spitzak and is currently maintained by a
small group of developers across the world with a central
repository in the US.

This package includes header files, static library, GUI builder fluid,
needed to develop FLTK applications.

%package doc
Summary: Documentation and test suit for multiplatform C++ GUI Fast Light ToolKit
Group: Development/C
Provides: %oname-doc = %version-%release
BuildArch: noarch

%description doc
The Fast Light ToolKit ("FLTK", pronounced "fulltick") is a LGPL'd
C++ graphical user interface toolkit for X (UNIX(r)), OpenGL(r),
and Microsoft(r) Windows(r) NT 4.0, 95, or 98. It was originally
developed by Mr. Bill Spitzak and is currently maintained by a
small group of developers across the world with a central
repository in the US.

This package includes test suit and documentation, needed to develop
FLTK applications.

%prep
%setup
perl -pi -e 's/\bcat([1-3])\b/man$1/g' documentation/Makefile

install -p -m644 %SOURCE1 .

%build
cmake \
	-DOPTION_PREFIX_LIB:STRING=%_libdir \
	-DOPTION_PREFIX_CONFIG:STRING=%_libdir/FLTK-%major \
	.
#configure --enable-shared --enable-xdbe --enable-xft --enable-threads
%make_build

pushd documentation
doxygen
popd

%install
install -d %buildroot%_docdir/fltk-%version
install -d %buildroot%_mandir

%makeinstall_std docdir=%buildroot%_docdir/fltk-%version
cp -p ANNOUNCEMENT CHANGES CREDITS README %buildroot%_docdir/fltk-%version/
cp -fR documentation/html %buildroot%_docdir/fltk-%version/

mv %buildroot%prefix/man/* %buildroot%_mandir/

%files
%_libdir/*.so.*
%dir %_docdir/fltk-%version
%_docdir/fltk-%version/ANNOUNCEMENT
%_docdir/fltk-%version/CREDITS
%_docdir/fltk-%version/README

%files -n %oname-devel
%_bindir/*
%_libdir/*.so
%_includedir/*
%_libdir/FLTK-1.3
%_mandir/man?/*

%files doc
%_docdir/fltk-%version
%exclude %_docdir/fltk-%version/ANNOUNCEMENT
%exclude %_docdir/fltk-%version/CREDITS
%exclude %_docdir/fltk-%version/README

%changelog
