# Ahtung! While g-ir-generate fails on Folks-0.6.typelib
#%%add_findreq_skiplist %_typelibdir/*

%define _name folks
%define ver_major 0.9
%define api_ver 0.6
%def_disable static
%def_enable introspection
%def_enable vala
%def_enable libsocialweb
%def_enable tracker

Name: lib%_name
Version: %ver_major.1
Release: alt1

Summary: GObject contact aggregation library
Group: System/Libraries
License: LGPLv2+
Url: http://telepathy.freedesktop.org/wiki/Folks

Source: http://download.gnome.org/sources/%_name/%ver_major/%_name-%version.tar.xz
# git archive --format=tar --prefix=folks-0.6.0/ --output=folks-0.6.0.tar HEAD
#Source: %_name-%version.tar

%define glib_ver 2.26.0
%define tp_glib_ver 0.19.0
%define vala_ver 0.15.1
%define eds_ver 3.7.90
%define tracker_ver 0.15.2
%define gee_ver 0.8.4
%define zeitgeist_ver 0.3.14

BuildRequires: gnome-common intltool libgio-devel >= %glib_ver libdbus-glib-devel
BuildRequires: libtelepathy-glib-devel >= %tp_glib_ver libgee0.8-devel >= %gee_ver
BuildRequires: evolution-data-server-devel >= %eds_ver
BuildRequires: libzeitgeist-devel >= %zeitgeist_ver vala-tools
%{?_enable_tracker:BuildRequires: tracker-devel >= %tracker_ver}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgee-gir-devel libtelepathy-glib-gir-devel evolution-data-server-gir-devel libgee0.8-gir-devel}
%{?_enable_vala:BuildRequires: vala >= %vala_ver vala-tools >= %vala_ver libtelepathy-glib-vala evolution-data-server-vala}
%{?_enable_libsocialweb:BuildRequires: libsocialweb-devel libsocialweb-gir-devel %{?_enable_vala:libsocialweb-vala}}

# for tools
BuildRequires: libreadline-devel libncurses-devel libxml2-devel
# for check
BuildRequires: dbus-tools-gui

%description
%name is a library that aggregates people from multiple sources (e.g.
Telepathy connection managers and eventually evolution data server,
Facebook, etc.) to create meta-contacts.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the %_name library
Group: System/Libraries
Requires: %name = %version-%release
Provides: typelib(Folks) = %ver_major

%description gir
GObject introspection data for the %_name library

%package gir-devel
Summary: GObject introspection devel data for the %_name library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the %_name library

%package vala
Summary: vala language bindings for %_name library
Group: Development/Other
BuildArch: noarch
Requires: %name = %version-%release

%description vala
This package provides vala language bindings for %_name library

%prep
%setup -q -n %_name-%version

%build
%autoreconf
%configure \
	%{subst_enable static} \
	%{subst_enable vala} \
	%{?_enable_eds:--enable-eds-backend} \
	%{?_enable_tracker:--enable-tracker-backend} \
	%{?_enable_libsocialweb:--enable-libsocialweb-backend=yes}

%make_build

%check
#%make check

%install
%makeinstall_std

%find_lang %_name

%files -f %_name.lang
%_libdir/*.so.*
%_libdir/%_name/
%_datadir/GConf/gsettings/folks.convert
%_datadir/glib-2.0/schemas/org.freedesktop.folks.gschema.xml
%doc AUTHORS README

%files devel
%_bindir/folks-import
%{?_enable_vala:%_bindir/folks-inspect}
%_includedir/%_name
%_libdir/*.so
%_libdir/pkgconfig/%{_name}*.pc

%if_enabled introspection
%files gir
%_typelibdir/Folks-%api_ver.typelib

%files gir-devel
%_girdir/Folks-%api_ver.gir
%endif

%if_enabled vala
%files vala
%_vapidir/folks.deps
%_vapidir/folks-eds.deps
%_vapidir/folks-eds.vapi
%_vapidir/folks-libsocialweb.deps
%_vapidir/folks-libsocialweb.vapi
%_vapidir/folks-telepathy.deps
%_vapidir/folks-telepathy.vapi
%_vapidir/folks-tracker.deps
%_vapidir/folks-tracker.vapi
%_vapidir/folks.vapi
%endif

%changelog
