Name: libfreetype
Version: 2.4.11
Release: alt1.1

Summary: A free and portable font rendering engine
License: FTL or GPLv2+
Group: System/Libraries
Url: http://www.freetype.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source0: http://download.savannah.gnu.org/releases/freetype/freetype-%version.tar.bz2
Source2: http://download.savannah.gnu.org/releases/freetype/freetype-doc-%version.tar.bz2
Source1: http://download.savannah.gnu.org/releases/freetype/ft2demos-%version.tar.bz2

Patch5: freetype-2.4.10-osh.patch

Patch1: freetype-2.4.10-alt-compat-version-script.patch
Patch2: freetype-2.4.10-alt-freetype-config.patch
Patch3: freetype-2.4.10-alt-fttrigon.patch
Patch4: ft2demos-2.4.10-alt-drop-ftgrid.patch

Patch11: freetype-2.4.10-rh-enable-subpixel-rendering.patch
Patch12: freetype-2.4.10-rh-enable-valid.patch
Patch13: ft2demos-2.4.10-rh-more-demos.patch

Patch21: ft2demos-2.4.10-deb-fixes.patch

Provides: freetype2 = %version
Obsoletes: freetype2 < %version

%def_disable static

BuildRequires: libX11-devel zlib-devel

%description
The FreeType engine is a free and portable TrueType font rendering
engine, developed to provide TrueType support for a variety of
platforms and environments.  FreeType is a library which can open
and manages font files as well as efficiently load, hint and render
individual glyphs.  FreeType is not a font server or a complete
text-rendering library.

%package devel
Summary: Header files and library for development with FreeType2
Group: Development/C
Requires: %name = %version-%release
Provides: freetype2-devel = %version
Obsoletes: freetype2-devel < %version

%description devel
This package contains the header files and development libraries needed
to develop programs that use the FreeType2 library.

%package devel-static
Summary: The FreeType2 static library
Group: Development/C
Requires: %name-devel = %version-%release
Provides: freetype2-devel-static = %version
Obsoletes: freetype2-devel-static < %version

%description devel-static
This package contains the FreeType2 static library.

%package demos
Summary: A collection of FreeType demonstration programs
Group: Development/C
Requires: %name = %version-%release
Provides: freetype2-demos = %version
Obsoletes: freetype2-demos < %version
Conflicts: freetype

%description demos
The FreeType engine is a free and portable TrueType font rendering
engine, developed to provide TrueType support for a variety of
platforms and environments.  FreeType is a library which can open
and manages font files as well as efficiently load, hint and render
individual glyphs.  FreeType is not a font server or a complete
text-rendering library.

This package contains collection of FreeType demonstration programs.

%prep
%setup -n freetype-%version -a1 -b2
ln -s ft2demos-%version ft2demos

%patch5 -p1

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p0

%patch11 -p1
%patch12 -p1
%patch13 -p0

%patch21 -p0

%build
%add_optflags -fno-strict-aliasing %(getconf LFS_CFLAGS)
%configure %{subst_enable static}

# get rid of RPATH
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' builds/unix/libtool

%make_build
%make_build -C ft2demos-%version TOP_DIR=..

%install
%makeinstall_std

for f in ft2demos-%version/bin/ft*; do
	builds/unix/libtool --mode=install install -m755 $f %buildroot%_bindir/
done

wordsize=$(echo -e '#include <bits/wordsize.h>\n__WORDSIZE' | cpp -P | sed '/^$/d')
[ "$wordsize" -ge 32 ]
mv %buildroot%_includedir/freetype2/freetype/config/ftconfig{,-$wordsize}.h
cat >%buildroot%_includedir/freetype2/freetype/config/ftconfig.h << EOF
#ifndef __FTCONFIG_H__MULTILIB
#define __FTCONFIG_H__MULTILIB

#include <bits/wordsize.h>

#if __WORDSIZE == 32
# include <freetype/config/ftconfig-32.h>
#elif __WORDSIZE == 64
# include <freetype/config/ftconfig-64.h>
#else
# error "unexpected value for __WORDSIZE macro"
#endif

#endif
EOF

%define docdir %_docdir/%name-%version
%define develdocdir %_docdir/%name-devel-%version
mkdir -p %buildroot%docdir
mkdir -p %buildroot%develdocdir
cp -a docs/* %buildroot%develdocdir/
pushd %buildroot%develdocdir
	bzip2 -9 CHANGES raster.txt
	rm INSTALL* release
popd
mv %buildroot%develdocdir/{FTL.TXT,LICENSE.TXT,CHANGES.bz2} %buildroot%docdir/

%set_verify_elf_method strict

%files
%docdir
%_libdir/*.so.*

%files devel
%develdocdir
%_bindir/*-config
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_datadir/aclocal/*.m4

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files demos
%_bindir/ft*

%changelog
