%define freetypemajorversion 6

Name: libfreetype-infinality
Version: 2.4.11
Release: alt6.M70P.2

Summary: A free and portable font rendering engine with patches from http://www.infinality.net
License: FTL or GPLv2+
Group: System/Libraries
Url: http://www.freetype.org/
Packager: Vladimir Didenko <cow@altlinux.ru>

Source0: %name-%version.tar

Source91: infinality-settings.sh
Source92: README.infinality

Patch1: freetype-2.4.10-alt-compat-version-script.patch
Patch2: freetype-2.4.10-alt-freetype-config.patch
Patch3: freetype-2.4.10-alt-fttrigon.patch

Patch11: freetype-2.4.10-rh-enable-subpixel-rendering.patch
Patch12: freetype-2.4.10-rh-enable-valid.patch

#Infinality patches
Patch91: freetype-enable-subpixel-hinting-infinality-20120615-01.patch
Patch92: freetype-entire-infinality-patchset-20130104-01.patch

Provides: freetype2-infinality = %version
Obsoletes: freetype2-infinality < %version

%def_disable static

BuildRequires: libX11-devel zlib-devel

%description
The FreeType engine is a free and portable TrueType font rendering
engine, developed to provide TrueType support for a variety of
platforms and environments.  FreeType is a library which can open
and manages font files as well as efficiently load, hint and render
individual glyphs.  FreeType is not a font server or a complete
text-rendering library.

This version is compiled with the Infinality patches. It transparently
overrides the system library using ld.so.conf.d mechanism.

%prep
%setup -n %name-%version 

%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch11 -p1
%patch12 -p1

%patch91 -p1
%patch92 -p1

%build
%add_optflags -fno-strict-aliasing
%define libdir %{_libdir}/%name
%configure %{subst_enable static} \
    --libdir=%libdir

# get rid of RPATH
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' builds/unix/libtool

%make_build

%install
%makeinstall_std

%define ld_so_conf %_sysconfdir/ld.so.conf.d/%name-%_arch.conf
ld_so_conf=%ld_so_conf
mkdir -p %buildroot${ld_so_conf%%/*}
echo %_libdir/%name > %buildroot%ld_so_conf
chmod 644 %buildroot%ld_so_conf
%filter_from_provides '/^libfreetype\.so\./d'

mkdir -p %buildroot%_sysconfdir/X11/profile.d
install -pm755 %SOURCE91 %buildroot%_sysconfdir/X11/profile.d/

%define docdir %{_docdir}/%name-%version
mkdir -p %buildroot%docdir
cp -a docs/{FTL.TXT,LICENSE.TXT,CHANGES} %buildroot%docdir/
pushd %buildroot%docdir
    bzip2 -9 CHANGES 
popd
cp %SOURCE91 %buildroot%docdir
cp %SOURCE92 %buildroot%docdir
cp %PATCH91 %buildroot%docdir
cp %PATCH92 %buildroot%docdir

#remove devel data. Infinality package is not oriented on any development
rm -f %buildroot%_bindir/*-config
rm -f %buildroot%libdir/*.so
rm -f %buildroot%libdir/*.la
rm -fr %buildroot%_includedir/
rm -fr %buildroot%libdir/pkgconfig/
rm -f %buildroot%_datadir/aclocal/*.m4

%set_verify_elf_method strict

%files
%docdir
%_libdir/%name/
%config %_sysconfdir/X11/profile.d/infinality-settings.sh
%config %ld_so_conf

%changelog
