Summary:   Library to program and control the FTDI USB serial controllers
Name:      libftdi1
Version:   1.0
Release:   alt1
License:   LGPL for libftdi and GPLv2+linking exception for the C++ wrapper
Group:     System/Libraries
URL:       http://www.intra2net.com/en/developer/libftdi
Packager:  Evgeny Sinelnikov <sin@altlinux.ru>

Source:    %name-%version.tar
BuildRequires: libusb-devel, pkg-config, doxygen
BuildRequires: gcc-c++ boost-devel
BuildRequires: rpm-macros-cmake
BuildRequires: cmake swig
BuildRequires: python-devel rpm-build-python

%define    namepp libftdipp1
%define    pyname python-module-ftdi1

%define    soname libftdi1
%define    sonamepp libftdipp1

Patch:     %name-%version-%release.patch

%package   -n %namepp
Summary:   C++ interface for libftdi library
Group:     System/Libraries

%package   devel
Summary:   Header files and libraries for libftdi
Group:     Development/C
Requires:  %name = %version, libusb-devel

%package   -n %namepp-devel
Summary:   Header files and libraries for libftdipp
Group:     Development/C
Requires:  %name-devel = %version
Requires:  boost-devel

%package   devel-static
Summary:   Static libraries for libftdi
Group:     Development/C
Requires:  %name-devel = %version
Conflicts: libftdi-devel

%package   -n %namepp-devel-static
Summary:   Static libraries for libftdipp
Group:     Development/C
Requires:  %namepp-devel = %version

%package   -n %pyname
Summary:   Python bindings for libftdi
Group:     Development/Python
Requires:  %name = %version

%package   docs
Summary:   Documentation files for libftdi
Group:     Development/C
BuildArch: noarch

%description 
Userspace library to program and control the FTDI
USB controllers, using libusb, including the popular
bitbang mode. This library talks to next FTDI chips:
FT232BM/245BM, FT2232C/D and FT232/245R.

%description -n %namepp
Full C++ wrapper for libftdi library

%description devel
Header files for userspace libftdi library

%description -n %namepp-devel
Header files for full libftdi library C++ wrapper

%description devel-static
Static libraries for userspace libftdi library

%description -n %namepp-devel-static
Static libraries for full libftdi library C++ wrapper

%description -n %pyname
Python bindings for libftdi library

%description docs
Documentation files for userspace libftdi library

%prep
%setup
%patch -p1

%build
%cmake_insource
%make_build VERBOSE=1

%install
%makeinstall_std

# Install python bindings
mkdir -p %buildroot%python_sitelibdir

# Install man pages
mkdir -p %buildroot%_mandir
cp -a doc/man/* %buildroot%_mandir/
mv %buildroot%_man3dir/size_and_time.3 %buildroot%_man3dir/ftdi_size_and_time.3

%files
%_libdir/%soname.so.*

%files -n %namepp
%_libdir/%sonamepp.so.*

%files devel
%_bindir/%soname-config
%_libdir/%soname.so
%_libdir/pkgconfig/%soname.pc
%_includedir/%name/*.h
%_libdir/cmake/%name/*.cmake

%files -n %namepp-devel
%_libdir/%sonamepp.so
%_libdir/pkgconfig/%sonamepp.pc
%_includedir/%name/*.hpp

%files devel-static
%_libdir/%soname.a

%files -n %namepp-devel-static
%_libdir/%sonamepp.a

%files -n %pyname
%python_sitelibdir/*.py*
%python_sitelibdir/*.so

%files docs
%doc doc/html
%_man3dir/*

%changelog
