%define _name garcon

%def_without builtin_menu

Name: lib%_name
Version: 0.2.1
Release: alt1.M70P.1

Summary: Implementation of the freedesktop.org menu specification
License: %lgpl2plus
Group: System/Libraries
URL: http://xfce.org/
Packager: Xfce Team <xfce@packages.altlinux.org>

# Upstream: git://git.xfce.org/xfce/garcon
Source: %name-%version.tar
Patch: %name-%version-%release.patch

# Fix crash with empty directory-files.
# From https://bugzilla.xfce.org/show_bug.cgi?id=10381
Patch1: 0001-Bail-out-of-creating-a-directory-menu-if-it-doesn-t.patch

BuildRequires(pre): rpm-build-licenses

BuildPreReq: rpm-build-xfce4 >= 0.1.0 xfce4-dev-tools
BuildPreReq: libxfce4util-devel
BuildRequires: glib2-devel >= 2.14
BuildRequires: libgtk+2-devel >= 2.12.0
BuildRequires: gtk-doc
BuildRequires: intltool

Obsoletes: libxfce4menu
Requires: xfce-freedesktop-menu

%description
Garcon is an implementation of the freedesktop.org menu specification
replacing the former Xfce menu library libxfce4menu. It is based on
GLib/GIO only and aims at covering the entire specification except
for legacy menus.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Requires: libgtk+2-devel >= 2.12.0

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: Development files for %name
License: GFDLv1.1
Group: Development/C
Conflicts: %name-devel < %version
BuildArch: noarch

%description devel-doc
This package contains development documentation for %name.

%package freedesktop-menu
Summary: xfce menu shipped by default with %name
Group: Graphical desktop/XFce
Provides: xfce-freedesktop-menu
# because of %%_datadir/desktop-directories/xfce-*
Conflicts: xfdesktop <= 4.6.2
# to avoid conflicts during update
Requires: %name = %version-%release
BuildArch: noarch

%description freedesktop-menu
%summary

%package settings-manager-menu
Summary: Xfce menu directories for use with xfce4-settings.
Group: Graphical desktop/XFce
Requires: %name = %version-%release
BuildArch: noarch

%description settings-manager-menu
%summary

%prep
%setup
%patch -p1
%patch1 -p1

%build
%xfce4reconf
%configure \
    --disable-static \
    --enable-gtk-doc
%make_build

%install
%makeinstall_std
%find_lang %_name

%files -f %_name.lang
%doc AUTHORS NEWS README
%_libdir/*.so.*

%if_with builtin_menu
%files freedesktop-menu
%_datadir/desktop-directories/*
%config(noreplace) %_sysconfdir/xdg/menus/xfce-applications.menu
%else
%exclude %_datadir/desktop-directories/*
%exclude %_sysconfdir/xdg/menus/xfce-applications.menu
%endif

%files settings-manager-menu
%_datadir/desktop-directories/xfce-hardware.directory
%_datadir/desktop-directories/xfce-personal.directory
%_datadir/desktop-directories/xfce-other.directory
%_datadir/desktop-directories/xfce-system.directory

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%files devel-doc
%doc HACKING STATUS TODO
%doc %_datadir/gtk-doc/html/%_name

%changelog
