%define _name gconfmm
%define api_version 2.6
%define major 2.28

Name: libgconfmm2
Version: %major.2
Release: alt2

Summary: A C++ interface for GConf2
License: LGPL
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://ftp.gnome.org/pub/GNOME/sources/%_name/%major/%_name-%version.tar.bz2

BuildPreReq: doxygen
BuildRequires: mm-common gcc-c++ libGConf-devel libgtkmm2-devel

%description
This package provides a C++ interface for gconf2.  It is a subpackage
of the Gtk-- project.  The interface provides a convenient interface for C++
programmers to create Gnome GUIs with GTK+'s flexible object-oriented
framework.

%package devel
Summary: Headers and development files of GConf 2 C++ wrapper
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
This package contains the headers and various development files needed,
when compiling or developing programs which want GConf 2 C++ wrapper.

%package doc
Summary: Documentation of %_name library
Group: Development/C++
BuildArch: noarch
Conflicts: %name-devel < %version

%description doc
This package provides API documentation of %_name library.

%define pkgdocdir %_docdir/%_name-%api_version

%prep
%setup -q -n %_name-%version

%build
mm-common-prepare
%autoreconf
%configure \
           --disable-static \
           --enable-shared

%make_build

%install
%make DESTDIR=%buildroot install

%files
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files devel
%_includedir/%_name-%api_version/
%_libdir/%_name-%api_version/
%_pkgconfigdir/%_name-%api_version.pc
%_libdir/*.so

%files doc
%_datadir/devhelp/books/*
%pkgdocdir/reference/

%changelog
