%def_enable gnome
%def_enable goa

Name: libgdata
Version: 0.13.3
Release: alt1

Summary: Library for the GData protocol
Group: System/Libraries
License: LGPLv2+
URL: http://live.gnome.org/libgdata
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %name-%version.tar.xz

%define soup_ver 2.37.91
%define goa_ver 3.7.90

BuildRequires: gnome-common gtk-doc intltool
BuildRequires: libgdk-pixbuf-devel libgtk+3-devel liboauth-devel gobject-introspection-devel
%{?_enable_gnome:BuildRequires: gcr-libs-devel libxml2-devel libsoup-gnome-devel >= %soup_ver libsoup-gnome-gir-devel}
%{?_enable_goa:BuildRequires: libgnome-online-accounts-devel >= %goa_ver libgnome-online-accounts-gir-devel}

%description
libgdata is a GLib-based library for accessing online service APIs using the
GData protocol --- most notably, Google's services. It provides APIs to access
the common Google services, and has full asynchronous support.

%package gir
Summary: GObject introspection data for the GData library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GData library.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir-devel
Summary: GObject introspection devel data for the GData library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the GData library.

%prep
%setup
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
	--enable-gtk-doc \
	%{subst_enable gnome} \
	%{subst_enable goa} \
	--enable-introspection \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang gdata

%check
# network connection required for tests
#%%make check

%files -f gdata.lang
%doc NEWS README AUTHORS
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/%name.pc
%_datadir/gtk-doc/html/gdata

%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir

%changelog
