%define major 3.8
%define _unpackaged_files_terminate_build 1

Name: libgdl3
Version: %major.1
Release: alt1

Summary: Gnome docking library (GDL)

License: %gpl2plus
Group: System/Libraries
Url: http://www.gnome.org

Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

Source: %name-%version.tar

Provides: gdl = %version

BuildRequires(pre): rpm-build-licenses rpm-build-gnome
# From configure.in
BuildPreReq: gnome-common
BuildPreReq: libgtk+3-devel >= 3.0.0
BuildPreReq: libxml2-devel >= 2.2.8
BuildPreReq: intltool >= 0.40.0
BuildPreReq: gettext-tools
BuildPreReq: gtk-doc >= 1.4
BuildPreReq: gobject-introspection-devel >= 0.6.7 libgtk+3-gir-devel
BuildRequires: gcc-c++

%description
GDL contains components and libraries that are intended to be
shared between GNOME development tools, including gnome-debug,
gnome-build, and anjuta.  Currently GDL include:

  o A symbol browser bonobo component (symbol-browser-control).
  o A docking widget (gdl).
  o A utility library that also contains the stubs and skels for
    the symbol browser and text editor components (gdl, idl).

%package gir
Summary: GObject introspection data for the gdl library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the WebkitGTK library

%package gir-devel
Summary: GObject introspection devel data for the gdl library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the gdl library


%package devel
Summary: Gnome Devtool Libraries
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
GDL contains components and libraries that are intended to be
shared between GNOME development tools, including gnome-debug,
gnome-build, and anjuta.

This package contains headers and other development files needed
to develop/compile applications that need GNOME development tools.

%package devel-doc
Summary: Development documentation for gdl
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package provides development documentation for gdl.


%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q

%build
NOCONFIGURE=1 ./autogen.sh
%configure --enable-gtk-doc --disable-static
%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang gdl-3

%check
%make check

%files -f gdl-3.lang
%doc README
#%dir %_datadir/gdl-3
#%dir %_datadir/gdl-3/ui
#%_datadir/gdl-3/ui/*.ui
%_libdir/lib*.so.*

%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir

%files devel
%doc AUTHORS ChangeLog MAINTAINERS NEWS
%dir %_includedir/libgdl-3.0
%dir %_includedir/libgdl-3.0/gdl
%_includedir/libgdl-3.0/gdl/*
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%files devel-doc
%_gtk_docdir/*

%changelog
