%def_disable docs

Name: libgegl
Version: 0.2.0
Release: alt1
Summary: A graph based image processing framework
License: LGPLv3+/GPLv3+
Group: System/Libraries
Url: http://www.gimp.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: gegl-%version.tar
Patch: gegl-%version-%release.patch

BuildRequires: asciidoc gcc-c++ graphviz glib2-devel gtk-doc intltool libSDL-devel libavformat-devel libbabl-devel libjpeg-devel libopenraw-devel
BuildRequires: librsvg-devel libspiro-devel openexr-devel python-modules-encodings ruby w3m liblua5-devel libgtk+2-devel enscript
BuildRequires: libexiv2-devel libjasper-devel libpng-devel liblensfun-devel

%description
GEGL (Generic Graphics Library) is a graph based image processing framework.
GEGLs original design was made to scratch GIMPs itches for a new
compositing and processing core. This core is being designed to have
minimal dependencies. and a simple well defined API.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains the libraries and header files needed for
developing with %name.

%prep
%setup -q -n gegl-%version
%patch -p1

%build
%autoreconf
%configure \
	%{subst_enable docs} \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang gegl-0.2

%files -f gegl-0.2.lang
%_bindir/gegl
%_libdir/*.so.*
%dir %_libdir/gegl-0.2
%_libdir/gegl-0.2/*.so

%files devel
%_includedir/gegl-0.2
%_libdir/*.so
%_pkgconfigdir/*.pc
%if_enabled docs
%_datadir/gtk-doc/html/gegl
%endif

%changelog
