%define _name geoclue
%define gitdate 20090310
%define git_version 3a31d26
%define tarfile %_name-%version-%gitdate.tar.gz
#%define snapshot %{gitdate}git%git_version
%define snapshot %nil

# Tarfile created using git
# git clone git://anongit.freedesktop.org/geoclue
# git archive --format=tar --prefix=geoclue-0.11.1.1/ %git_version | gzip > ~/RPM/SOURCES/geoclue-0.11.1.1-20090310.tar.gz

Name: lib%_name
Version: 0.12.99
Release: alt1%snapshot

Summary: A modular geoinformation service
Group: System/Libraries
License: LGPLv2
Url: http://geoclue.freedesktop.org/

Source: http://folks.o-hand.com/jku/geoclue-releases/%_name-%version.tar.gz
#Source: %tarfile

BuildRequires: libdbus-glib-devel
BuildRequires: glib2-devel
BuildRequires: libxml2-devel
BuildRequires: libGConf2-devel
BuildRequires: libgtk+2-devel
BuildRequires: NetworkManager-glib-devel
BuildRequires: libgypsy-devel
BuildRequires: libgps-devel >= 2.91
# for skyhook provider
BuildRequires: libsoup-gnome-devel
BuildRequires: gtk-doc

%description
Geoclue is a modular geoinformation service built on top of the D-Bus
messaging system. The goal of the Geoclue project is to make creating
location-aware applications as simple as possible.

%package devel
Summary: Development package for geoclue
Group: Development/C
Requires: %name = %version-%release

%description devel
Files for development with geoclue.

%package devel-doc
Summary: Developer documentation for geoclue
Group: Development/C
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
Developer documentation for geoclue

%package -n %_name-gui
Summary: Testing gui for geoclue
Group: Development/C
Requires: %name = %version-%release

%description -n %_name-gui
Testing gui for geoclue

%package -n %_name-gpsd
Summary: gpsd provider for geoclue
Group: Monitoring
Requires: %name = %version-%release
Requires: gpsd

%description -n %_name-gpsd
A gpsd provider for geoclue

%package -n %_name-gypsy
Summary: gypsy provider for geoclue
Group: Monitoring
Requires: %name = %version-%release
Requires: gypsy-daemon

%description -n %_name-gypsy
A gypsy provider for geoclue

%prep
%setup -q -n %_name-%version

%build
%autoreconf
%configure --disable-static --enable-gtk-doc
# SMP-incompatible build
%make

%install
make install DESTDIR=%buildroot
# Install the test gui as it seems the test isn't installed any more
mkdir %buildroot%_bindir
cp test/.libs/geoclue-test-gui %buildroot%_bindir/

%files
%dir %_datadir/geoclue-providers
%_libdir/libgeoclue.so.0
%_libdir/libgeoclue.so.0.0.0
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Master.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Example.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Geonames.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Hostip.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Localnet.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Manual.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Plazes.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Yahoo.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Gsmloc.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Nominatim.service
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Skyhook.service
%_datadir/geoclue-providers/geoclue-example.provider
%_datadir/geoclue-providers/geoclue-geonames.provider
%_datadir/geoclue-providers/geoclue-hostip.provider
%_datadir/geoclue-providers/geoclue-localnet.provider
%_datadir/geoclue-providers/geoclue-manual.provider
%_datadir/geoclue-providers/geoclue-plazes.provider
%_datadir/geoclue-providers/geoclue-yahoo.provider
%_datadir/geoclue-providers/geoclue-gsmloc.provider
%_datadir/geoclue-providers/geoclue-nominatim.provider
%_datadir/geoclue-providers/geoclue-skyhook.provider
%_libexecdir/geoclue-example
%_libexecdir/geoclue-geonames
%_libexecdir/geoclue-hostip
%_libexecdir/geoclue-localnet
%_libexecdir/geoclue-manual
%_libexecdir/geoclue-master
%_libexecdir/geoclue-plazes
%_libexecdir/geoclue-yahoo
%_libexecdir/geoclue-gsmloc
%_libexecdir/geoclue-nominatim
%_libexecdir/geoclue-skyhook
%_datadir/GConf/gsettings/geoclue
%_datadir/glib-2.0/schemas/org.freedesktop.Geoclue.gschema.xml
%doc AUTHORS README

%files devel
%_includedir/geoclue
%_libdir/libgeoclue.so
%_libdir/pkgconfig/geoclue.pc

%files devel-doc
%_datadir/gtk-doc/html/geoclue/

%files -n %_name-gui
%_bindir/geoclue-test-gui

%files -n %_name-gpsd
%_libexecdir/geoclue-gpsd
%_datadir/geoclue-providers/geoclue-gpsd.provider
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Gpsd.service

%files -n %_name-gypsy
%_libexecdir/geoclue-gypsy
%_datadir/geoclue-providers/geoclue-gypsy.provider
%_datadir/dbus-1/services/org.freedesktop.Geoclue.Providers.Gypsy.service

%changelog
