%define ver_major 1.36
%define _name gjs
%define api_ver 1.0

Name: lib%_name
Version: %ver_major.1
Release: alt1

Summary: Javascript Bindings for GNOME
Group: System/Libraries
# The following files contain code from Mozilla which
# is triple licensed under MPL1.1/LGPLv2+/GPLv2+:
# The console module (modules/console.c)
# Stack printer (gjs/stack.c)
License: MIT and (MPLv1.1 or GPLv2+ or LGPLv2+)
Url: https://live.gnome.org/Gjs/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

%define glib_ver 2.36.0
%define gi_ver 1.36.0

BuildRequires: gnome-common gcc-c++ libmozjs-devel >= 1.8.5 libcairo-devel
BuildRequires: glib2-devel >= %glib_ver gobject-introspection-devel >= %gi_ver
BuildRequires: libdbus-glib-devel libreadline-devel libcairo-gobject-devel

# for check
BuildRequires: /proc dbus-tools-gui

%description
Gjs allows using GNOME libraries from Javascript. It's based on the
Spidermonkey Javascript engine from Mozilla and the GObject introspection
framework.

%package devel
Summary: Development package for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
Files for development with %name.

%set_typelibdir %_libdir/%_name/girepository-1.0

%prep
%setup -q -n %_name-%version

%build
%autoreconf
%configure \
    --disable-static

%make_build

%install
%make DESTDIR=%buildroot install

%check
%make check

%files
%_bindir/%_name
%_bindir/%_name-console
%_libdir/%name.so.*
%dir %_libdir/%_name/
%dir %_typelibdir
%_typelibdir/GjsPrivate-1.0.typelib
%_datadir/%_name-%api_ver
%doc COPYING NEWS README

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%name.so
%_libdir/pkgconfig/%_name-%api_ver.pc
%_libdir/pkgconfig/%_name-internals-%api_ver.pc

%doc examples/*

%changelog
