%define devhelp_bookdir %_datadir/devhelp/books

%define req_libglade_version 2.5.1
%define req_gtkmm_version 2.12.0

%define api_version 2.4
%define libname_basic glademm
%define major 2.6

Name: libglademm
Version: %major.7
Release: alt2.qa2
Summary: C++ interface of glade2 library
License: LGPL
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: http://ftp.gnome.org/pub/GNOME/sources//%name/%major/%name-%version.tar.bz2

BuildRequires: doxygen gcc-c++ graphviz libglade-devel libgtkmm2-devel xsltproc
BuildPreReq: libglade2-devel >= %req_libglade_version
BuildPreReq: libgtkmm2-devel >= %req_gtkmm_version

%description
This package provides a C++ interface for glade2.  It is a subpackage
of the Gtk-- project.  The interface provides a convenient interface for C++
programmers to create glade2 objects.

%package devel
Summary: Development related files of %name
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Requires: libglade2-devel >= %req_libglade_version

%description devel
Thie package provides headers and various development files needed for
compiling or developing applications that use Glade 2 C++ interface.

%package doc
Summary: Documentation for %name
Group: Development/GNOME and GTK+

%description doc
Thie package provides documentation for
compiling or developing applications that use Glade 2 C++ interface.

%prep
%setup -q
subst "s|gnomemm-2.6/libglademm-2.4/docs|%name-%version|g" docs/reference/doxygen_to_devhelp.xsl

%build
%configure \
	--disable-static

%make_build

%install
%make DESTDIR=%buildroot docdir=%_docdir/%name-doc-%version install

%files
%doc AUTHORS
%_libdir/%{name}*.so.*

%files devel
%doc AUTHORS ChangeLog INSTALL
%_includedir/*
%_libdir/%name-%api_version
%_pkgconfigdir/%name-%api_version.pc
%_libdir/%{name}*.so

%files doc
%devhelp_bookdir/%name-%api_version/
%_docdir/%name-doc-%version

%changelog
