%define rname glibmm
%define major 2.36
%def_disable snapshot

Name: libglibmm
Version: %major.2
Release: alt1

Summary: C++ wrapper for GLib
License: LGPL
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

%if_enabled snapshot
Source: %rname-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/glibmm/%major/%rname-%version.tar.xz
%endif

%define glib_ver 2.36.1

AutoReq: yes, noperl
BuildRequires: gcc-c++ libgio-devel >= %glib_ver libsigc++2.0-devel
BuildRequires: mm-common perl-XML-Parser doxygen xsltproc graphviz

%description
A C++ interface for glib library.

This package contains the library needed to run programs dynamically
linked with glibmm.

%package devel
Summary: Headers and development files of glibmm
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
A C++ interface for glib library.

This package contains the headers and development files that are needed,
when trying to develop or compile applications which need glibmm.

%package doc
Summary: glibmm documentation
Group: Development/Documentation
BuildArch: noarch

%description doc
Gtkmm provides a C++ interface to the GTK+ GUI library.
glibmm originally belongs to gtkmm, but is now separated,
for use with non-GUI software written in C++.

This package contains all API documentation for glibmm.

%add_findreq_skiplist %_libdir/%rname-2.4/proc/*

%prep
%setup -q -n %rname-%version

%build
%if_enabled snapshot
mm-common-prepare --force --copy
%endif

%autoreconf
%configure \
	--disable-static \
%if_enabled snapshot
	--enable-maintainer-mode \
	--enable-documentation
%endif

%make_build

%install
%makeinstall_std

%check
%make check

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%_includedir/g*mm-2.4
%_libdir/*.so
%_libdir/g*mm-2.4
%_pkgconfigdir/*.pc
%_datadir/devhelp/books/%rname-2.4

%files doc
%_docdir/%rname-2.4

%changelog
