%define _name gmime
%def_disable static
%define ver_major 2.6

Name: lib%_name%ver_major
Version: %ver_major.18
Release: alt1

Summary: MIME library
License: LGPLv2+
Group: System/Libraries
Url: http://spruce.sourceforge.net/%_name/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %name-%version.tar

BuildPreReq: rpm-build-mono rpm-build-gnome
BuildPreReq: glib2-devel >= 2.18.0 libgio-devel
BuildPreReq: libgpgme-devel
BuildPreReq: zlib-devel
BuildPreReq: libgtk-sharp2-devel >= 2.4.0 libgtk-sharp2-gapi
BuildPreReq: gtk-doc >= 1.8 docbook-utils
BuildRequires: gcc-c++ mono-mcs mono-devel
BuildRequires: gobject-introspection-devel >= 1.30.0
BuildRequires: libvala-devel vala vala-tools
BuildRequires: /proc

%description
GMime is a set of utilities for parsing and creating messages using
the Multipurpose Internet Mail Extension (MIME)

%package -n lib%_name-devel
Summary: Development files for libgmime
Group: Development/C
PreReq: %name = %version-%release

%description -n lib%_name-devel
This package contains development files required for packaging
libgmime-based software.

%package gir
Summary: GObject introspection data for the gmime library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the gmime library

%package -n lib%_name-gir-devel
Summary: GObject introspection devel data for the gmime library
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name-gir = %version-%release

%description -n lib%_name-gir-devel
GObject introspection devel data for the gmime library

%package -n lib%_name-devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description -n lib%_name-devel-doc
This package provides development documentation for %name.

%package sharp
Summary: C# bindings
Group: Development/Other
PreReq: %name = %version-%release

%description sharp
C# bindings for %_name

%package -n lib%_name-sharp-devel
Summary: Development files for libgmime-sharp
Group: Development/Other
PreReq: %name-sharp = %version-%release

%description -n lib%_name-sharp-devel
Development files for libgmime-sharp

%package -n lib%_name-devel-static
Summary: Static libraries for libgmime
Group: Development/C
PreReq: %name-devel = %version-%release

%description -n lib%_name-devel-static
This package contains development libraries required for packaging
statically linked libgmime-based software.

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q

%build
gtkdocize --copy
#./autogen.sh
%autoreconf
%configure  %{subst_enable static} \
	    --disable-rpath \
	    --enable-mono \
	    --enable-introspection \
	    --enable-vala \
	    --enable-largefile \
	    --enable-gtk-doc \
	    --enable-smime
%make

%install
%make_install DESTDIR=%buildroot install

%files
%doc AUTHORS ChangeLog README
%_libdir/lib*.so.*

%files -n lib%_name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/%_name-%ver_major.pc
%_datadir/vala/vapi/*.vapi
%_datadir/vala/vapi/*.deps

%files gir
%_typelibdir/*.typelib

%files -n lib%_name-gir-devel
%_girdir/*.gir

%files -n lib%_name-devel-doc
%_gtk_docdir/*

%files sharp
%_monogacdir/gmime-sharp
%_monodir/gmime-sharp-*

%files -n lib%_name-sharp-devel
%_pkgconfigdir/gmime-sharp-*.pc
%_datadir/gapi-2.0/*.xml

%if_enabled static
%files -n lib%_name-devel-static
%_libdir/*.a
%endif

%changelog
