%define ver_major 3.8
%def_disable static
%def_disable gtk_doc
%def_disable debug
%def_enable introspection
%def_enable vala

Name: libgnome-keyring
Version: %ver_major.0
Release: alt1

Summary: Compatibility library for accessing secrets
License: LGPL
Group: System/Libraries
Url: http://www.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Source1: %name.map

%define glib_ver 2.16.0
%define dbus_ver 1.0
%define gcrypt_ver 1.2.2

# From configure.in
BuildPreReq: intltool >= 0.35.0
BuildPreReq: glib2-devel >= %glib_ver libgio-devel
BuildPreReq: libdbus-devel >= %dbus_ver
BuildPreReq: libgcrypt-devel >= %gcrypt_ver
BuildRequires: gtk-doc
BuildRequires: libvala-devel vala-tools rpm-build-vala
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}

# for check
BuildRequires: /proc xvfb-run

%description
The %name library is used by applications to integrate with the
gnome-keyring system.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains headers and development libraries for %name.

%package devel-static
Summary: Static version of %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package provides libraries for develop programs statically linked
against %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: %name < %version
BuildArch: noarch

%description devel-doc
This package contains development documentation for %name

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for %name

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for %name

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q

install -p -m644 %SOURCE1 library/%name-altlinux.ver

%build
%autoreconf
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable static} \
	%{subst_enable debug} \
	%{subst_enable vala}

%make_build

# X11 required for tests
%check
xvfb-run %make check

%install
%make_install DESTDIR=%buildroot install

%find_lang %name

%files -f %name.lang
%_libdir/*.so.*
%doc README AUTHORS NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*
%_vapidir/gnome-keyring-1.vapi

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files devel-doc
%_gtk_docdir/*

%if_enabled introspection
%files gir
%_typelibdir/GnomeKeyring-1.0.typelib

%files gir-devel
%_girdir/GnomeKeyring-1.0.gir
%endif

%changelog
