%define ver_major 3.6
%def_enable introspection

Name: libgnomekbd
Version: %ver_major.0
Release: alt1

Summary: GNOME keyboard shared library
License: %lgpl2plus
Group: Graphical desktop/GNOME
URL: http://www.gnome.org/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Obsoletes: gnome-kbd-indicator < 2.22.0
Provides: gnome-kbd-indicator = %version-%release

%define glib_ver 2.28.0
%define gtk_ver 2.91.6
%define libxklavier_ver 5.2.1

BuildPreReq: rpm-build-gnome >= 0.4
BuildPreReq: rpm-build-licenses

# from configure.in
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libxklavier-devel >= %libxklavier_ver
BuildPreReq: intltool >= 0.35.0
BuildPreReq: libX11-devel libXt-devel
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel libgtk+3-gir-devel libxklavier-gir-devel}

%description
GNOME keyboard shared library.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
GNOME keyboard shared library.

This is package contain development files for %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GNOME keyboard library

%package gir-devel
Summary: GObject introspection devel data for %name
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GNOME keyboard library

%prep
%setup -q

%build
%autoreconf
%configure \
	--disable-schemas-compile \
	--disable-static
%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang --with-gnome %name

%check
%make check

%files -f %name.lang
%_libdir/lib*.so.*
%doc AUTHORS NEWS

%_bindir/gkbd-keyboard-display
%_desktopdir/gkbd-keyboard-display.desktop
%_datadir/%name
%config %_datadir/glib-2.0/schemas/org.gnome.libgnomekbd.desktop.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.libgnomekbd.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.libgnomekbd.keyboard.gschema.xml
%_datadir/GConf/gsettings/%name.convert

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled introspection
%files gir
%_typelibdir/*.typelib

%files gir-devel
%_girdir/*.gir
%endif

%changelog
