%define _unpackaged_files_terminate_build 1
%define oldname libgnomeprint2
%define ver_major 2.18
%def_disable static
%def_disable gtk_doc

%def_with cups

Name: libgnomeprint
Version: %ver_major.8
Release: alt3.M70P.1

Summary: Printing library for GNOME
License: LGPL
Group: System/Libraries

Provides: %oldname = %version-%release
Obsoletes: %oldname < 2.12.1-alt3

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2
Patch: %name-2.18.6-alt-configure.patch
Patch1: %name-2.18.8-include.patch
Patch2: %name-bison3.patch

%define glib_ver 2.6.3
%define libxml2_ver 2.6.17
%define pango_ver 1.8.1
%define libart_lgpl_ver 2.3.17
%define libbonobo_ver 2.8.1
%define fontconfig_ver 2.2.1-alt2
%define gtk_doc_ver 1.3
%define cups_ver 1.1.20

Requires: fontconfig >= %fontconfig_ver

BuildPreReq: rpm-build-gnome
BuildPreReq: intltool >= 0.35.0
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: libart_lgpl-devel >= %libart_lgpl_ver
BuildPreReq: libbonobo2-devel >= %libbonobo_ver
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: gtk-doc >= %gtk_doc_ver
BuildPreReq: libfreetype-devel >= 2.0.5
%if_with cups
BuildPreReq: libssl-devel
BuildPreReq: libgnomecups-devel >= 0.2.0
BuildPreReq: libcups-devel >= %cups_ver
%endif

BuildRequires: docbook-utils flex gcc-c++ libgnutls-devel perl-XML-Parser bison zlib-devel

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System. The gnome-print package contains
libraries needed by GNOME applications for printing.

You should install the %name package if you intend to use any of
the GNOME applications that can print. If you would like to develop
GNOME applications that can print you will also need to install the
%name-devel package.

%package devel
Summary: Libraries and include files for developing GNOME applications
Group: Development/GNOME and GTK+
Provides: %oldname-devel = %version-%release
Obsoletes: %oldname-devel < 2.12.1-alt3
Requires: %name = %version-%release

%description devel
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System. The %name-devel package
includes the libraries and include files needed for developing
applications that use the GNOME printing capabilities.

You should install the %name-devel package if you would like to
develop GNOME applications that will use the GNOME print capabilities.
You do not need to install the %name-devel package if you just
want to use the GNOME desktop environment.

%package devel-doc
Summary: Libraries and include files for developing GNOME applications
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System. The %name-devel-doc package
includes the documenation needed for developing
applications that use the GNOME printing capabilities.

%package devel-static
Summary: static libraries and objects for gnomeprint
Group: Development/GNOME and GTK+
Provides: %oldname-devel-static = %version-%release
Obsoletes: %oldname-devel-static < 2.12.1-alt3
Requires: %name-devel = %version-%release

%description devel-static
This package contains static libraries for the GNOME printing infrastructure.

%prep
%setup
%patch
%patch1 -p1
%patch2 -p1

%build
%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_with cups} \
    %{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%makeinstall_std

%find_lang %name-2.2

%files -f %name-2.2.lang
%_libdir/*.so.*
%dir %_libdir/%name
%dir %_libdir/%name/%version
%dir %_libdir/%name/%version/modules
%dir %_libdir/%name/%version/modules/transports
%dir %_libdir/%name/%version/modules/filters
%_libdir/%name/%version/modules/transports/*.so
%_libdir/%name/%version/modules/filters/*.so
%_libdir/%name/%version/modules/libgnomeprintlpd.so
%if_with cups
%_libdir/%name/%version/modules/libgnomeprintcups.so
%endif
%dir %_datadir/%name
%dir %_datadir/%name/%version
%dir %_datadir/%name/%version/models
%dir %_datadir/%name/%version/printers
%_datadir/%name/%version/models/*
%_datadir/%name/%version/printers/*
%_datadir/%name/%version/*.xml
%doc AUTHORS ChangeLog NEWS README

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%dir %_libdir/%name/%version/modules/transports/*.a
%endif

%exclude %_libdir/%name/%version/modules/transports/*.la
%exclude %_libdir/%name/%version/modules/filters/*.la
%exclude %_libdir/%name/%version/modules/*.la

%changelog
