%define ver_major 2.18
%def_disable static
%def_disable gtk_doc

%define _unpackaged_files_terminate_build 1

Name: libgnomeprintui
Version: %ver_major.6
Release: alt1.M70P.1

Summary: GUI support for libgnomeprint
License: LGPL
Group: System/Libraries
Url: ftp://ftp.gnome.org

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2
Patch:  %name-remove-missing-include-dir.patch

%define libgnomeprint_ver 2.18.7
%define libgnomecanvas_ver 2.10.0

PreReq: libgnomeprint2 >= %libgnomeprint_ver
PreReq: libgnomecanvas >= %libgnomecanvas_ver

BuildPreReq: rpm-build-gnome gnome-common
BuildPreReq: intltool >= 0.35.0
BuildPreReq: libgtk+2-devel >= 2.6.0
BuildPreReq: libgnomeprint-devel >= %libgnomeprint_ver
BuildPreReq: libgnomecanvas-devel >= %libgnomecanvas_ver
BuildPreReq: gnome-icon-theme
BuildPreReq: libglade-devel
BuildRequires: gcc-c++ gtk-doc

%description
The libgnomeprintui package contains GTK+ widgets related to printing.

%package devel
Summary: Libraries and headers for libgnomeprintui
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
The libgnomeprintui package contains GTK+ widgets related to printing.

You should install the libgnomeprintui-devel package if you would like
to compile applications that use the widgets in libgnomeprintui. You
do not need to install it if you just want to use precompiled
applications.

%package devel-doc
Summary: Development documentation for libgnomeprintui
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
The libgnomeprintui package contains GTK+ widgets related to printing.

You can install the libgnomeprintui-devel-doc package if you would like
to develop applications that use the widgets in libgnomeprintui.

%package devel-static
Summary: Static libraries and objects
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release

%description devel-static
Static libraries and objects for the GNOME Printing User Interface.

%prep
%setup -q
%patch -p2

%build
%autoreconf
%configure \
    %{subst_enable static} \
    %{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%makeinstall

%find_lang %name-2.2

%files -f %name-2.2.lang
%_libdir/*.so.*
%dir %_datadir/%name
%dir %_datadir/%name/%version
%_datadir/%name/%version/*.xml
%doc AUTHORS ChangeLog NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
