%define ver_major 2.24
%def_disable static
%def_disable gtk_doc

# For some reason, the above construct doesn't work is some places of the spec.
#define _disable_static --disable-static
%define _unpackaged_files_terminate_build 1

Name: libgnomeui
Version: %ver_major.5
Release: alt1

Summary: GNOME base GUI library
License: LGPL
Group: System/Libraries
Url: ftp://ftp.gnome.org

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2

# From configure.in
%define libxml_ver 2.4.20
%define libgnome_ver 2.13.7
%define libgnomecanvas_ver 2.0.0
%define libbonoboui_ver 2.13.1
%define GConf_ver 1.1.11
%define pango_ver 1.1.2
%define glib_ver 2.16.0
%define gio_ver 2.16.0
%define gtk_ver 2.12.0
%define gnome_vfs_ver 2.7.3
%define glade_ver 2.0.0
%define gnome_keyring_ver 0.4


Obsoletes: %name-utils
Provides: %name-utils = %version-%release

BuildPreReq: rpm-build-gnome
# From configure.in
BuildPreReq: libxml2-devel >= %libxml_ver
BuildPreReq: libgnome-devel >= %libgnome_ver
BuildPreReq: libgnomecanvas-devel >= %libgnomecanvas_ver
BuildPreReq: libbonoboui-devel >= %libbonoboui_ver
BuildPreReq: libGConf2-devel >= %GConf_ver
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: gnome-vfs2-devel >= %gnome_vfs_ver
BuildPreReq: libgnome-keyring-devel >= %gnome_keyring_ver
BuildPreReq: intltool >= 0.35
BuildPreReq: gnome-common
BuildPreReq: libX11-devel libXt-devel libSM-devel libICE-devel
BuildPreReq: libjpeg-devel
BuildPreReq: gtk-doc >= 1.0
BuildPreReq: libpopt-devel
BuildPreReq: libgio-devel >= %gio_ver
BuildPreReq: libglade-devel >= %glade_ver
BuildRequires: gcc-c++ imake perl-XML-Parser xorg-cf-files

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
GUI applications and desktop tools to be used in conjunction with a
window manager for the X Window System. The libgnomeui package
includes GUI-related libraries that are needed to run GNOME. (The
libgnome package includes the library features that don't use the X
Window System.)

%package devel
Summary: Libraries and headers for libgnome
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
GNOME (GNU Network Object Model Environment) is a user-friendly set of
GUI applications and desktop tools to be used in conjunction with a
window manager for the X Window System. The libgnomeui-devel package
includes the libraries and include files that you will need to
use libgnomeui.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
GNOME (GNU Network Object Model Environment) is a user-friendly set of
GUI applications and desktop tools to be used in conjunction with a
window manager for the X Window System. The libgnomeui package
includes GUI-related libraries that are needed to run GNOME.

This package provides development documentation for %name.

%if_enabled static
%package devel-static
Summary: Static libraries for libgnome
Group: Development/GNOME and GTK+
Requires: %name-devel = %version-%release

%description devel-static
GNOME (GNU Network Object Model Environment) is a user-friendly set of
GUI applications and desktop tools to be used in conjunction with a
window manager for the X Window System. The libgnomeui-devel package
includes the libraries and include files that you will need to
use libgnomeui.

You should install the libgnomeui-devel-static package if you would like
to compile GNOME applications. You do not need to install libgnomeui-devel
if you just want to use the GNOME desktop environment.
%endif

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q

%build
export DATADIRNAME=share
%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc}

%make

%install
%make_install DESTDIR=%buildroot install

bzip2 -9f ChangeLog

%find_lang %name-2.0

%files -f %name-2.0.lang
%_libdir/*.so.*
%_libdir/libglade/2.0/*.so
%_datadir/pixmaps/*
%doc AUTHORS ChangeLog.bz2 NEWS

%files devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%_libdir/libglade/*/*.a
%endif

%exclude %_libdir/libglade/*/*.la

%changelog
