%def_enable static

Name: libgpg-error
Version: 1.17
Release: alt0.M70P.1

Group: System/Libraries
Summary: Error library for GnuPG and related projects
License: LGPL
URL: http://www.gnupg.org/

Packager: Sergey V Turchin <zerg@altlinux.org>

Source: %name-%version.tar.bz2
Source1: version-script.map
Source2: compat.lds
# PLD
Patch1: libgpg-error-am18.patch
# ALT
Patch10: libgpg-error-alt-version-script.patch

# Automatically added by buildreq on Wed Jun 02 2010 (-bi)
#BuildRequires: cvs glibc-devel-static libsubversion-auth-gnome-keyring libsubversion-auth-kwallet rpm-build-qt4 subversion
BuildRequires: cvs glibc-devel
%if_enabled static
BuildRequires: glibc-devel-static
%endif

%package devel
Summary: Development files for the %name package
Group: Development/C
Requires: %name = %version-%release

%package devel-static
Summary: Static libraries for the %name-devel package
Group: Development/C
Requires: %name-devel = %version-%release

%description
This is a library that defines common error values for all GnuPG
components.  Among these are GPG, GPGSM, GPGME, GPG-Agent, libgcrypt,
pinentry, SmartCard Daemon and possibly more in the future.

%description devel
This package contains files needed to develop
applications using the GnuPG error library.

%description devel-static
Static build of the GnuPG error library.

%prep
%setup -q
#%patch1 -p1
#%patch10 -p1

#cat %SOURCE1 >>src/gpg-error.vers
#install -m 0644 %SOURCE2 src/
%autoreconf

%build
%configure %{subst_enable static} --disable-rpath
%make_build
%make check

%install
%makeinstall
%find_lang %name

%files -f %name.lang
%_libdir/lib*.so.*
%_bindir/gpg-error
%doc AUTHORS ChangeLog NEWS README

%files devel
%_bindir/*-config
%_libdir/*.so
%_includedir/*
%_datadir/aclocal/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
