%define sover 6
%define sover_port 10
%def_disable static
%def_enable hal
%def_disable libhal
%define _libexecdir /usr/libexec

Name: libgphoto2
Version: 2.5.2
Release: alt1

Group: System/Libraries
Summary: Library to access to digital cameras
Summary (ru_RU.UTF-8): Библиотека функций для работы с цифровыми фотокамерами
Url: http://www.gphoto.org/
License: LGPLv2+
Packager: Dmitriy Khanzhin <jinn@altlinux.ru>

# Automatically added by buildreq on Mon Oct 11 2010
BuildRequires: doxygen flex gcc-c++ libexif-devel libgd2-devel libjpeg-devel liblockdev-devel libltdl7-devel libusb-compat-devel libusb-devel libxml2-devel
%if_enabled libhal
BuildRequires: libhal-devel
%endif

# IMHO, this build requires are needs when build with cdk
#BuildRequires: libncurses-devel libtinfo-devel

# Url for source code downloads now http://sourceforge.net/project/showfiles.php?group_id=8874
Source0: %name-%version.tar
Patch0:  %name-2.5.2-alt-fix-underlinked_libraries.patch

%description
This library contains all the functionality to access to modern digital
cameras via USB or the serial port.

%package -n %name-devel
Group: Development/C
Summary: Headers and links to compile against the %name library
Summary (ru_RU.UTF-8): Заголовочные и другие файлы для компиляции приложений с библиотекой libgphoto2
License: LGPLv2+
Requires: %name = %version-%release
Conflicts: %{name}_2.4-devel

%description -n %name-devel
This package contains all files which one needs to compile programs using
the %name library.

%if_enabled static
%package -n %name-devel-static
Group: Development/C
Summary: Static versions of %name
Summary (ru_RU.UTF-8): Статические версии библиотек libgphoto2
License: LGPLv2+
Requires: %name-devel = %version-%release
Conflicts: %{name}_2.4-devel-static

%description -n %name-devel-static
This package contains libraries which one needs to compile programs statically linked
against %name library.
%endif

##### TRANSLATED DESCRIPTIONS  #####

%description -l ru_RU.UTF-8
Библиотека предоставляет все необходимые функции для обмена данными
с современными цифровыми фотокамерами посредством USB или последовательного порта.

%description -n %name-devel -l ru_RU.UTF-8
Пакет содержит все необходимые файлы для компиляции программ, использующих
библиотеку libgphoto2.

%if_enabled static
%description -n %name-devel-static  -l ru_RU.UTF-8
Пакет содержит статические версии библиотек для компиляции программ, использующих
библиотеку libgphoto2.
%endif

%prep
%setup -n %name-%version
%patch0 -p1

%build
sed -i '/driverdir/d' libgphoto2_port/libgphoto2_port.pc.in
%add_optflags -I/usr/include/libxml2
%autoreconf
export udevscriptdir=/lib/udev
export utilsdir=%_libexecdir/%name
%configure \
    %{subst_enable static} \
    --with-drivers=all \
%if_disabled libhal
    --without-hal \
%endif
    --disable-rpath
%make_build

%install
%makeinstall_std

# create udev support
/bin/mkdir -p %buildroot/lib/udev/rules.d/
/bin/touch %buildroot/lib/udev/rules.d/40-%name.rules

%if_enabled hal
# create hal support
/bin/mkdir -p %buildroot%_datadir/hal/fdi/information/20thirdparty/
/bin/touch %buildroot%_datadir/hal/fdi/information/20thirdparty/10-camera-%name.fdi
%endif

# correct content of doc. directory
for f in %{name}_port/{AUTHORS,NEWS,README}
do /bin/cp -pr $f ${f}.port ; done

# remove circular symlink in /usr/include/gphoto2
/bin/rm -f %buildroot%_includedir/gphoto2/gphoto2
# udev helper not used now
/bin/rm -f %buildroot/lib/udev/check-ptp-camera
# remove .la files
/bin/rm -f %buildroot%_libdir/%name/*/*.la
/bin/rm -f %buildroot%_libdir/%{name}_port/*/*.la

%find_lang --output=%name.lang %name-%sover
%find_lang --append --output=%name.lang %{name}_port-%sover_port

##### PRE/POST INSTALL SCRIPTS #####

%pre
# create group
/usr/sbin/groupadd -fr camera || :

%post
# create udev rules
%_libexecdir/%name/print-camera-list --verbose udev-rules version 175 owner root mode 0660 group camera > /lib/udev/rules.d/40-%name.rules
%if_enabled hal
# create .fdi file
%_libexecdir/%name/print-camera-list hal-fdi > %_datadir/hal/fdi/information/20thirdparty/10-camera-libgphoto2.fdi
%endif

%triggerpostun -- %name <= 2.4.0
/sbin/ldconfig


##### FILE LISTS FOR ALL BINARY PACKAGES #####

%files -f %name.lang
%_libdir/*.so.*
%dir %_libdir/%name
%dir %_libdir/%name/*
%_libdir/%name/*/*.so
%dir %_libdir/%{name}_port
%dir %_libdir/%{name}_port/*
%dir %_libexecdir/%name
%_libexecdir/%name/print-camera-list
%_libdir/%{name}_port/*/*.so
%_datadir/%name
%ghost /lib/udev/rules.d/*
%doc {AUTHORS,NEWS,README}
%doc %{name}_port/{AUTHORS,NEWS,README}.port
%if_enabled hal
%_datadir/hal/fdi/information/20thirdparty/*
%endif

%files -n %name-devel
%_bindir/*-config
%_includedir/gphoto2
%_libdir/*.so
%_libdir/pkgconfig/*
%_man3dir/%{name}*
%doc %_docdir/%name/README.apidocs
%doc %_docdir/%name/libgphoto2-api.html
%doc %_docdir/%name/camlibs

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%_libdir/%name/*/*.a
%_libdir/%{name}_port/*/*.a
%endif

%changelog
