%define pname libgphoto2
%define soname 2
%define soname_port 0
%def_disable static
%def_enable hal
%def_disable libhal

Name: %{pname}_2.4
Version: 2.4.14
Release: alt3

Group: System/Legacy libraries
Summary: Library to access to digital cameras
Summary (ru_RU.UTF-8): Библиотека функций для работы с цифровыми фотокамерами
Url: http://www.gphoto.org/
License: LGPLv2+
Packager: Dmitriy Khanzhin <jinn@altlinux.ru>

# Automatically added by buildreq on Mon Oct 11 2010
BuildRequires: doxygen flex gcc-c++ libexif-devel libgd2-devel libjpeg-devel liblockdev-devel libltdl7-devel libusb-compat-devel libusb-devel
%if_enabled libhal
BuildRequires: libhal-devel
%endif

# IMHO, this build requires are needs when build with cdk
#BuildRequires: libncurses-devel libtinfo-devel

Requires: %pname >= 2.5.0

# Url for source code downloads now http://sourceforge.net/project/showfiles.php?group_id=8874
Source0: %pname-%version.tar
Patch0:  %pname-2.4.0-deb-70_increase_max_entries.patch
Patch1:  %pname-2.4.14-alt-fix-underlinked_libraries.patch

%description
This library contains all the functionality to access to modern digital
cameras via USB or the serial port.

%package -n %name-devel
Group: Development/C
Summary: Headers and links to compile against the %pname library
Summary (ru_RU.UTF-8): Заголовочные и другие файлы для компиляции приложений с библиотекой libgphoto2
License: LGPLv2+
Requires: %name = %version-%release
Conflicts: %pname-devel

%description -n %name-devel
This package contains all files which one needs to compile programs using
the %pname library.

%if_enabled static
%package -n %name-devel-static
Group: Development/C
Summary: Static versions of %pname
Summary (ru_RU.UTF-8): Статические версии библиотек libgphoto2
License: LGPLv2+
Requires: %name-devel = %version-%release
Conflicts: %pname-devel-static

%description -n %name-devel-static
This package contains libraries which one needs to compile programs statically linked
against %pname library.
%endif

##### TRANSLATED DESCRIPTIONS  #####

%description -l ru_RU.UTF-8
Библиотека предоставляет все необходимые функции для обмена данными
с современными цифровыми фотокамерами посредством USB или последовательного порта.

%description -n %name-devel -l ru_RU.UTF-8
Пакет содержит все необходимые файлы для компиляции программ, использующих
библиотеку libgphoto2.

%if_enabled static
%description -n %name-devel-static  -l ru_RU.UTF-8
Пакет содержит статические версии библиотек для компиляции программ, использующих
библиотеку libgphoto2.
%endif

%prep
%setup -n %pname-%version
%patch0 -p1
%patch1 -p1

%build
sed -i '/driverdir/d' libgphoto2_port/libgphoto2_port.pc.in
%autoreconf
export udevscriptdir=/lib/udev
%configure \
    %{subst_enable static} \
    --with-drivers=all \
%if_disabled libhal
    --without-hal \
%endif
    --disable-rpath
%make_build

%install
%makeinstall_std

# correct content of doc. directory
for f in %{pname}_port/{AUTHORS,NEWS,README}
do /bin/cp -pr $f ${f}.port ; done

# remove circular symlink in /usr/include/gphoto2
/bin/rm -f %buildroot%_includedir/gphoto2/gphoto2
# udev helper not used now
/bin/rm -f %buildroot/lib/udev/check-ptp-camera
# remove .la files
/bin/rm -f %buildroot%_libdir/%pname/*/*.la
/bin/rm -f %buildroot%_libdir/%{name}_port/*/*.la

%find_lang --output=%pname.lang %pname-%soname
%find_lang --append --output=%pname.lang %{pname}_port-%soname_port

##### FILE LISTS FOR ALL BINARY PACKAGES #####

%files -f %pname.lang
%_libdir/*.so.*
%_libdir/%pname/*/*.so
%_libdir/%{pname}_port/*/*.so
%_datadir/%pname
%doc {AUTHORS,NEWS,README}
%doc %{pname}_port/{AUTHORS,NEWS,README}.port

%files -n %name-devel
%_bindir/*-config
%_includedir/gphoto2
%_libdir/*.so
%_libdir/pkgconfig/*
%_man3dir/%{pname}*
%doc %_docdir/%pname/README.apidocs
%doc %_docdir/%pname/apidocs.html
%doc %_docdir/%pname/camlibs

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%_libdir/%pname/*/*.a
%_libdir/%{pname}_port/*/*.a
%endif

%changelog
