%define major 0.10
%define oname gstreamermm
Name: libgstreamermm
Version: %major.8
Release: alt2.1

Summary: C++ wrapper for GStreamer library

Group: Video
License: LGPLv2+
Url: http://www.gtkmm.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://ftp.gnome.org/pub/GNOME/sources/%oname/%major/%oname-%version.tar
Patch0: libgstreamermm-0.10.8-alt-glib2-2.32.0.patch

# Automatically added by buildreq on Wed Oct 07 2009
BuildRequires: doxygen gcc-c++ glibc-devel gst-plugins-devel libxml++2-devel mm-common

%description
GStreamermm is a C++ wrapper library for the multimedia library
GStreamer (http://gstreamer.freedesktop.org).  It is designed to allow
C++ development of applications that work with multi-media.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C++
Requires: %name = %version-%release

%description devel
This package contains the static libraries and header files needed for
developing gstreamermm applications.

%prep
%setup -n %oname-%version
%patch0 -p2

%build
export MMDOCTOOLDIR=/usr/share/mm-common/doctool/
%configure --enable-shared --disable-examples --enable-docs --disable-dependency-tracking
%make_build

%install
%makeinstall_std
find %buildroot -type f -name "*.la" -exec rm -f {} ';'
# Move documentation to gtk-doc directory
mkdir -p %buildroot%_datadir/gtk-doc/html
mv %buildroot%_docdir/%oname-0.10/reference/html %buildroot%_datadir/gtk-doc/html/%oname-0.10
# Removing code generation script stuff
rm -rf %buildroot%_libdir/gstreamermm-0.10

%files
%doc AUTHORS ChangeLog COPYING NEWS README
%_libdir/*.so.*

%files devel
%doc %_datadir/gtk-doc/html/%oname-0.10
%_includedir/gstreamermm-0.10/
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
