%def_disable snapshot

%define _name gtk+
%define api_ver 2.0
%define binary_ver 2.10.0
%define ver_major 2.24

%def_enable xkb

%if_enabled snapshot
%def_enable gtk_doc
%else
%def_disable gtk_doc
%endif

%def_enable man
%def_enable introspection

Name: libgtk+2
Version: %ver_major.21
Release: alt1

Summary: The GIMP ToolKit (GTK+), a library for creating GUIs
License: %lgpl2plus
Group: System/Libraries
Url: http://www.gtk.org
Icon: gtk+-logo.xpm
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Provides: libgtk2 = %version gtk2 = %version gtk+2 = %version gtk-engines-pixmap = %version
Obsoletes: libgtk2 < %version gtk2 < %version gtk+2 < %version gtk-engines-pixmap < %version
Provides: %name-common = %version
Obsoletes: %name-common <= %version

%if_enabled snapshot
Source: %_name-%version.tar
%else
Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz
%endif

Source1: %name-gdk.map
Source2: %name-gdk.lds
Source3: %name-gtk.map
Source4: %name-gtk.lds
Source5: gtk-icon-cache.filetrigger

Patch1: gtk+-2.16.5-alt-stop-spam.patch
Patch6: gtk+-2.10.6-fix-drop-gdk_colormap_change.patch

# https://bugzilla.gnome.org/show_bug.cgi?id=583273
Patch10: gtk+-2.20-icon-padding.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=599618
Patch12: gtk+-2.21.0-tooltip-positioning.patch

Patch20: gtk+-2.24.10-fixdso.patch

%define glib_ver 2.28.0
%define cairo_ver 1.6
%define pango_ver 1.28.3
%define atk_ver 1.32.0
%define directfb_ver 0.9.24
%define fontconfig_ver 2.2.1-alt2
%define gtk_doc_ver 1.6

Requires: %name-locales = %version
Requires: gtk-update-icon-cache = %version
Requires: icon-theme-hicolor

BuildPreReq: rpm-build-licenses rpm-build-gnome
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libcairo-devel >= %cairo_ver
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: libatk-devel >= %atk_ver
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: gtk-doc >= %gtk_doc_ver
BuildRequires: libgio-devel libgdk-pixbuf-devel libcairo-gobject-devel libcups-devel gcc-c++ indent zlib-devel
%if_enabled introspection
BuildRequires: gobject-introspection-devel libpango-gir-devel libatk-gir-devel >= %atk_ver libgdk-pixbuf-gir-devel
%endif
BuildRequires: libXdamage-devel libXcomposite-devel libX11-devel libXcursor-devel libXext-devel libXfixes-devel libXi-devel libXinerama-devel libXrandr-devel libXrender-devel

%description
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
Offering a complete set of widgets, GTK+ is suitable for projects
ranging from small one-off projects to complete application suites.

%package locales
Summary: Internationalization for GTK+
Group: System/Internationalization
Conflicts: %name < %version-%release
BuildArch: noarch

%description locales
This package provides internationalization support for GTK+,
the GIMP toolkit.

%package -n gtk-update-icon-cache
Summary: Icon theme caching utility for GTK+
Group: System/Libraries

%description -n gtk-update-icon-cache
gtk-update-icon-cache creates mmap()able cache files for icon themes.
GTK+ can use the cache files created by gtk-update-icon-cache to avoid
a lot of system call and disk seek overhead when the application starts.

%package -n gtk-builder-convert
Summary: Glade file conversion utility
Group: Development/GNOME and GTK+
BuildArch: noarch

%description -n gtk-builder-convert
gtk-builder-convert converts glade files into XML files which can be
loaded with GtkBuilder.

%package devel
Summary: Development files and tools for GTK+ applications
Group: Development/GNOME and GTK+
Icon: gtk+-devel-logo.xpm
Requires: %name = %version-%release
Requires: gtk-builder-convert = %version
Provides: libgtk2-devel = %version gtk2-devel = %version gtk+2-devel = %version
Obsoletes: libgtk2-devel < %version gtk2-devel < %version gtk+2-devel < %version
Provides: %name-common-devel = %version
Obsoletes: %name-common-devel <= %version

%description devel
This package contains development files for GTK+, X11 version. Use this to
build programs that use GTK+.

%package -n gtk-demo
Summary: GTK+ widgets demonstration program
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description -n gtk-demo
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains a program, along with its source code, that
demonstrates GTK+ variety of all its widgets.

%package devel-doc
Summary: Development documentation for GTK+
Group: Development/GNOME and GTK+
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description devel-doc
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains documentation needed for developing GTK+ applications.

%package devel-doc-examples
Summary: Examples for developing applications which will use GTK+
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc-examples
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains sources for example programs.

%package gir
Summary: GObject introspection data for the GTK+ library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GTK+ library

%package gir-devel
Summary: GObject introspection devel data for the GTK+ library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GTK+ library

%package -n libgail
Summary: Accessibility implementation for GTK+ and GNOME libraries
Group: System/Libraries
Requires: %name = %version-%release

%description -n libgail
GAIL implements the abstract interfaces found in ATK for GTK+ and GNOME libraries,
enabling accessibility technologies such as at-spi to access those GUIs.

%package -n libgail-devel
Summary: Files to compile applications that use GAIL
Group: Development/GNOME and GTK+
Requires: libgail = %version-%release
Requires: %name-devel = %version-%release

%description -n libgail-devel
This package contains the files required to develop applications against
the GAIL libraries.

%package -n libgail-devel-doc
Summary: Development documentation for GAIL
Group: Development/GNOME and GTK+
Conflicts: libgail < %version-%release
BuildArch: noarch

%description -n libgail-devel-doc
GAIL implements the abstract interfaces found in ATK for GTK+ and GNOME
libraries, enabling accessibility technologies such as at-spi to access
those GUIs.

This package contains development documentation for GAIL.

%define fulllibpath %_libdir/gtk-%api_ver/%binary_ver

%prep
%setup -q -n %_name-%version
install -p -m644 %_sourcedir/%name-gdk.map gdk/compat.map
install -p -m644 %_sourcedir/%name-gdk.lds gdk/compat.lds
install -p -m644 %_sourcedir/%name-gtk.map gtk/compat.map
install -p -m644 %_sourcedir/%name-gtk.lds gtk/compat.lds

%patch1 -p1
%patch6

%patch10 -p1 -b .icon-padding
%patch12 -p1 -b .tooltip-positioning
%patch20 -p1 -b .fixdso

bzip2 -9k NEWS

[ ! -d m4 ] && mkdir m4

%build
%if_enabled snapshot
NOCONFIGURE=1 ./autogen.sh
%else
%autoreconf
%endif
%configure \
    %{subst_enable xkb} \
    %{subst_enable man} \
    --with-xinput=yes \
    %{?_enable_gtk_doc:--enable-gtk-doc}

# SMP-incompatible build
%make LIBTOOL_EXPORT_OPTIONS=-Wl,--version-script=compat.map,compat.lds

%install
%make_install DESTDIR=%buildroot install
install -d %buildroot{%_sysconfdir/gtk-%api_ver,%_libdir/gtk-%api_ver/%binary_ver/engines}

touch %buildroot%_libdir/gtk-%api_ver/%binary_ver/immodules.cache

# system wide gtkrc
cat <<__RC__ > %buildroot%_sysconfdir/gtk-%api_ver/gtkrc
# This enables editing of menu accelerators by pressing
# an accelerator over the menu item.
gtk-can-change-accels = 1
__RC__

cat <<__SH__ >%name.sh
export GTK_PATH=\`getconf LIBDIR\`/gtk-%api_ver/%binary_ver
__SH__

cat <<__CSH__ >%name.csh
setenv GTK_PATH \`getconf LIBDIR\`/gtk-%api_ver/%binary_ver
__CSH__

install -pD -m755 %name.sh %buildroot%_sysconfdir/profile.d/%name.sh
install -pD -m755 %name.csh %buildroot%_sysconfdir/profile.d/%name.csh

%find_lang --output=gtk20.lang gtk20 gtk20-properties

# examples
mkdir -p %buildroot/%_docdir/%name-devel-%version
cp -a examples/ %buildroot/%_docdir/%name-devel-%version/

# rpm posttrans filetriggers
install -pD -m755 {%_sourcedir,%buildroot%_rpmlibdir}/gtk-icon-cache.filetrigger

# rpm posttrans filetrigger to update immodules cache
cat <<EOF > filetrigger
#!/bin/sh -e

dir=%fulllibpath/immodules
grep -qs '^'\$dir'' && %_bindir/gtk-query-immodules-%api_ver --update-cache ||:
EOF

install -pD -m 755 filetrigger %buildroot%_rpmlibdir/gtk-%api_ver-immodules-cache.filetrigger

%files
%doc AUTHORS NEWS.bz2 README
%_libdir/libgdk-x11-%api_ver.so.*
%_libdir/libgtk-x11-%api_ver.so.*
%dir %_libdir/gtk-%api_ver
%dir %_libdir/gtk-%api_ver/modules
%dir %fulllibpath
%dir %fulllibpath/engines
%fulllibpath/engines/libpixmap.so
%dir %fulllibpath/immodules
%fulllibpath/immodules/im-*.so
%dir %fulllibpath/printbackends
%fulllibpath/printbackends/libprintbackend-*.so
%exclude %fulllibpath/*/*.la
%dir %_datadir/themes
%_datadir/themes/Default
%_datadir/themes/Emacs
%_datadir/themes/Raleigh
%dir %_sysconfdir/gtk-%api_ver
%config(noreplace) %_sysconfdir/gtk-%api_ver/gtkrc
%config(noreplace) %_sysconfdir/gtk-%api_ver/im-multipress.conf
%ghost %_libdir/gtk-%api_ver/%binary_ver/immodules.cache
%_bindir/gtk-query-immodules-%api_ver
%_man1dir/gtk-query-immodules*
%_rpmlibdir/gtk-%api_ver-immodules-cache.filetrigger

%files locales -f gtk20.lang

%files -n gtk-update-icon-cache
%_bindir/gtk-update-icon-cache
%_man1dir/gtk-update-icon-cache*
%_rpmlibdir/gtk-icon-cache.filetrigger

%files -n gtk-builder-convert
%_bindir/gtk-builder-convert
%_man1dir/gtk-builder-convert*

%files devel
%dir %_includedir/gtk-%api_ver
%dir %_includedir/gtk-%api_ver/gdk
%_includedir/gtk-%api_ver/gdk/*.h
%dir %_includedir/gtk-%api_ver/gtk
%_includedir/gtk-%api_ver/gtk/*.h
%dir %_includedir/gtk-unix-print-%api_ver
%dir %_includedir/gtk-unix-print-%api_ver/gtk
%_includedir/gtk-unix-print-%api_ver/gtk/*.h
%dir %_libdir/gtk-%api_ver/include
%_libdir/gtk-%api_ver/include/*.h
%_libdir/libgdk-x11-%api_ver.so
%_libdir/libgtk-x11-%api_ver.so
%_pkgconfigdir/gdk-%api_ver.pc
%_pkgconfigdir/gtk+-%api_ver.pc
%_pkgconfigdir/gtk+-unix-print-%api_ver.pc
%_pkgconfigdir/gdk-x11-%api_ver.pc
%_pkgconfigdir/gtk+-x11-%api_ver.pc
%_datadir/aclocal/gtk-%api_ver.m4

%files -n gtk-demo
%_bindir/gtk-demo
%dir %_datadir/gtk-%api_ver
%dir %_datadir/gtk-%api_ver/demo
%_datadir/gtk-%api_ver/demo/*

%files devel-doc
%_datadir/gtk-doc/html/gdk2
%_datadir/gtk-doc/html/gtk2

%files devel-doc-examples
%doc %_docdir/%name-devel-%version/examples

%files -n libgail
%_libdir/libgailutil.so.*
%_libdir/gtk-%api_ver/modules/libferret.so
%_libdir/gtk-%api_ver/modules/libgail.so
%exclude %_libdir/gtk-%api_ver/modules/*.la

%files -n libgail-devel
%_includedir/gail-1.0
%_libdir/libgailutil.so
%_pkgconfigdir/gail.pc

%files -n libgail-devel-doc
%_datadir/gtk-doc/html/gail-libgail-util

%files gir
%_libdir/girepository-1.0/*

%files gir-devel
%_datadir/gir-1.0/*

%changelog
