%define _name gtk+
%define ver_major 3.8
%define api_ver 3.0
%define binary_ver 3.0.0

%def_enable xkb
%def_disable static
%def_disable gtk_doc
%def_enable man
%def_enable introspection
%def_enable colord
# wayland gdk backend
%def_enable wayland
# broadway (HTML5) gdk backend
%def_enable broadway


Name: libgtk+3
Version: %ver_major.9
Release: alt0.M70P.1

Summary: The GIMP ToolKit (GTK+)
Group: System/Libraries
License: %lgpl2plus
Url: http://www.gtk.org
Icon: gtk+-logo.xpm
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.xz
Patch: gtk+-2.16.5-alt-stop-spam.patch

%define glib_ver 2.35.3
%define cairo_ver 1.10
%define pango_ver 1.32.4
%define atk_ver 2.5.91
%define atspi_atk_ver 2.5.91
%define pixbuf_ver 2.27.1
%define fontconfig_ver 2.2.1-alt2
%define gtk_doc_ver 1.6
%define colord_ver 0.1.9
%define cups_ver 1.6

Requires: gtk-update-icon-cache
Requires: icon-theme-hicolor
%{?_enable_colord:Requires: colord}

BuildPreReq: rpm-build-licenses rpm-build-gnome
BuildPreReq: glib2-devel >= %glib_ver libgio-devel
BuildPreReq: libcairo-devel >= %cairo_ver
BuildPreReq: libcairo-gobject-devel >= %cairo_ver
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: libatk-devel >= %atk_ver
BuildPreReq: at-spi2-atk-devel >= %atk_ver
BuildPreReq: libgdk-pixbuf-devel >= %pixbuf_ver
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: gtk-doc >= %gtk_doc_ver
BuildPreReq: libcups-devel >= %cups_ver
BuildRequires: gtk-update-icon-cache docbook-utils zlib-devel

BuildRequires: libXdamage-devel libXcomposite-devel libX11-devel libXcursor-devel
BuildRequires: libXext-devel libXfixes-devel libXi-devel libXinerama-devel libXrandr-devel
BuildRequires: libXrender-devel libXt-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libpango-gir-devel libatk-gir-devel >= %atk_ver libgdk-pixbuf-gir-devel}
%{?_enable_colord:BuildRequires: libcolord-devel >= %colord_ver}
%{?_enable_wayland:BuildRequires: libwayland-client-devel libwayland-cursor-devel libEGL-devel libwayland-egl-devel libxkbcommon-devel}

# for check
BuildRequires: /proc dbus-tools-gui xvfb-run

%description
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
Offering a complete set of widgets, GTK+ is suitable for projects
ranging from small one-off projects to complete application suites.

This package contains X11 part of GTK+. It is required for GNOME 3 desktop
and programs.

%package devel
Summary: Development files and tools for GTK+ applications
Group: Development/GNOME and GTK+
Icon: gtk+-devel-logo.xpm
Requires: %name = %version-%release
Requires: gtk-builder-convert

%description devel
This package contains development files for GTK+, X11 version. Use this to
build programs that use GTK+.

%package -n gtk3-demo
Summary: GTK+ widgets demonstration program
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description -n gtk3-demo
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains a program, along with its source code, that
demonstrates GTK+ variety of all its widgets.

%package -n %name-devel-doc
Summary: Development documentation for GTK+
Group: Development/Documentation
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description -n %name-devel-doc
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains documentation needed for developing GTK+ applications.

%package -n %name-devel-doc-examples
Summary: Examples for developing applications which will use GTK+
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description -n %name-devel-doc-examples
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains sources for example programs.

%package -n %name-devel-static
Summary: Static libraries for GTK+ (GIMP ToolKit) applications
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description -n %name-devel-static
GTK+ is a multi-platform toolkit for creating graphical user interfaces.
This package contains the static libraries for GTK+.

%package gir
Summary: GObject introspection data for the GTK+ library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GTK+ library

%package gir-devel
Summary: GObject introspection devel data for the GTK+ library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GTK+ library

%package -n libgail3
Summary: Accessibility implementation for GTK+ and GNOME libraries
Group: System/Libraries
Requires: %name = %version-%release

%description -n libgail3
GAIL implements the abstract interfaces found in ATK for GTK+ and GNOME libraries,
enabling accessibility technologies such as at-spi to access those GUIs.

%package -n libgail3-devel
Summary: Files to compile applications that use GAIL
Group: Development/GNOME and GTK+
Requires: libgail3 = %version-%release
Requires: %name-devel = %version-%release

%description -n libgail3-devel
This package contains the files required to develop applications against
the GAIL libraries.

%package -n libgail3-devel-static
Summary: Static libraries of GAIL
Group: Development/GNOME and GTK+
Requires: libgail3-devel = %version-%release

%description -n libgail3-devel-static
This package contains the libraries required to compile applications
statically linked against the GAIL libraries.

%package -n libgail3-devel-doc
Summary: Development documentation for GAIL
Group: Development/Documentation
Conflicts: libgail3-devel < %version-%release
BuildArch: noarch

%description -n libgail3-devel-doc
GAIL implements the abstract interfaces found in ATK for GTK+ and GNOME
libraries, enabling accessibility technologies such as at-spi to access
those GUIs.

This package contains development documentation for GAIL.


%define fulllibpath %_libdir/gtk-%api_ver/%binary_ver

%prep
%setup -q -n %_name-%version
%patch -p1

# need to regenerate with current glib
rm -f gtk/gtkdbusgenerated.[hc]

%build
%{?_disable_static:export lt_cv_prog_cc_static_works=no}
%{?_enable_static:export lt_cv_prog_cc_static_works=yes}

export CFLAGS="$CFLAGS $(freetype-config --cflags)"
export LDLIBS="$LDLIBS $(freetype-config --libs)"

%autoreconf
%configure \
    %{subst_enable static} \
    %{subst_enable man} \
    --enable-x11-backend \
    %{subst_enable xkb} \
    --disable-schemas-compile \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    --enable-gtk2-dependency \
    %{subst_enable colord} \
    %{?_enable_wayland:--enable-wayland-backend} \
    %{?_enable_broadway:--enable-broadway-backend}

%make_build

%install
%make_install DESTDIR=%buildroot install
install -d %buildroot{%_sysconfdir/gtk-%api_ver,%_libdir/gtk-%api_ver/%binary_ver/engines}

touch %buildroot%_libdir/gtk-%api_ver/%binary_ver/immodules.cache

# system wide gtkrc
cat <<__RC__ > %buildroot%_sysconfdir/gtk-%api_ver/gtkrc
# This enables editing of menu accelerators by pressing
# an accelerator over the menu item.
gtk-can-change-accels = 1
__RC__

cat <<__SH__ >%name.sh

export GTK_PATH=\`getconf LIBDIR\`/gtk-%api_ver/%binary_ver
__SH__

cat <<__CSH__ >%name.csh

setenv GTK_PATH \`getconf LIBDIR\`/gtk-%api_ver/%binary_ver
__CSH__

install -pD -m755 %name.sh %buildroot%_sysconfdir/profile.d/%name.sh
install -pD -m755 %name.csh %buildroot%_sysconfdir/profile.d/%name.csh

# posttransfiletrigger to update immodules cache
cat <<EOF > filetrigger
#!/bin/sh -e

dir=%fulllibpath/immodules
grep -qs '^'\$dir'' && %_bindir/gtk-query-immodules-%api_ver --update-cache ||:
EOF

install -pD -m 755 filetrigger %buildroot%_rpmlibdir/gtk-%api_ver-immodules-cache.filetrigger

# The license
ln -sf %_licensedir/LGPL-2 COPYING

%find_lang --output=gtk30.lang gtk30 gtk30-properties
%find_lang --output=gail.lang gail

bzip2 -9kf NEWS

mkdir %buildroot%_libdir/gtk-%api_ver/modules

# examples
mkdir -p %buildroot/%_docdir/%name-devel-%version/examples
cp examples/*.c examples/Makefile* %buildroot/%_docdir/%name-devel-%version/examples/

%check
#xvfb-run %make check

%files -f gtk30.lang
%{?_enable_broadway:%_bindir/broadwayd}
%_bindir/gtk-query-immodules-%api_ver
%_bindir/gtk-launch
%_libdir/libgdk-3.so.*
%_libdir/libgtk-3.so.*
%dir %_libdir/gtk-%api_ver/modules
%dir %fulllibpath
%dir %fulllibpath/engines
%dir %fulllibpath/immodules
%fulllibpath/immodules/im-am-et.so
%fulllibpath/immodules/im-cedilla.so
%fulllibpath/immodules/im-cyrillic-translit.so
%fulllibpath/immodules/im-inuktitut.so
%fulllibpath/immodules/im-ipa.so
%fulllibpath/immodules/im-thai.so
%fulllibpath/immodules/im-ti-er.so
%fulllibpath/immodules/im-ti-et.so
%fulllibpath/immodules/im-viqr.so
%fulllibpath/immodules/im-multipress.so
%fulllibpath/immodules/im-xim.so
%dir %fulllibpath/printbackends
%fulllibpath/printbackends/libprintbackend-*.so
%dir %_datadir/themes/*/gtk-%{api_ver}*
%_datadir/themes/*/gtk-%{api_ver}/*.css
%dir %_sysconfdir/gtk-%api_ver
%config(noreplace) %_sysconfdir/gtk-%api_ver/gtkrc
%config(noreplace) %_sysconfdir/gtk-%api_ver/im-multipress.conf
#%config(noreplace) %_sysconfdir/profile.d/*
%ghost %_libdir/gtk-%api_ver/%binary_ver/immodules.cache
%{?_enable_broadway:%_man1dir/broadwayd.1.*}
%_man1dir/gtk-query-immodules*
%_man1dir/gtk-launch.*
%config %_datadir/glib-2.0/schemas/org.gtk.Settings.FileChooser.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gtk.Settings.ColorChooser.gschema.xml
%_rpmlibdir/gtk-%api_ver-immodules-cache.filetrigger
%doc --no-dereference COPYING
%doc AUTHORS NEWS.bz2 README


%files devel
%_includedir/gtk-%api_ver/
%_libdir/libgdk-3.so
%_libdir/libgtk-3.so
%_pkgconfigdir/gtk+-%api_ver.pc
%_pkgconfigdir/gtk+-x11-%api_ver.pc
%_pkgconfigdir/gdk-%api_ver.pc
%_pkgconfigdir/gdk-x11-%api_ver.pc
%_pkgconfigdir/gtk+-unix-print-%api_ver.pc
%dir %_datadir/gtk-%api_ver
%_datadir/gtk-%api_ver/gtkbuilder.rng
%_datadir/aclocal/gtk-%api_ver.m4

%if_enabled wayland
%_pkgconfigdir/gtk+-wayland-%api_ver.pc
%_pkgconfigdir/gdk-wayland-%api_ver.pc
%endif

%if_enabled broadway
%_pkgconfigdir/gdk-broadway-3.0.pc
%_pkgconfigdir/gtk+-broadway-3.0.pc
%endif

%files -n gtk3-demo
%_bindir/gtk3-demo
%_bindir/gtk3-demo-application
%_bindir/gtk3-widget-factory
%_datadir/glib-2.0/schemas/org.gtk.Demo.gschema.xml

%files devel-doc
%_datadir/gtk-doc/html/*
%exclude %_datadir/gtk-doc/html/gail-libgail-util3

%files devel-doc-examples
%doc %_docdir/%name-devel-%version/examples

%if_enabled static
%files -n %name-devel-static
%_libdir/*.a
%fulllibpath/*/*.a

%files -n libgail3-devel-static
%_libdir/libgailutil.a
%endif

%files -n libgail3 -f gail.lang
%_libdir/libgailutil-3.so.*

%files -n libgail3-devel
%_includedir/gail-%api_ver
%_libdir/libgailutil-3.so
%_pkgconfigdir/gail-%api_ver.pc

%files -n libgail3-devel-doc
%_datadir/gtk-doc/html/gail-libgail-util3

%if_enabled introspection
%files gir
%_typelibdir/*

%files gir-devel
%_girdir/*
%endif

%exclude %fulllibpath/*/*.la

%changelog
