%define ver_major 0.8
%define real_name gtkmathview

Name: lib%real_name
Version: %ver_major.0
Release: alt4.2

Summary: A MathML rendering library
License: LGPL
Group: System/Libraries
Url: http://www.gnome.org

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%real_name-%version.tar.gz

Packager: Damir Shayhutdinov <damir@altlinux.ru>

Patch1: gtkmathview-0.7.7-without-binreloc.patch
Patch2: gtkmathview-0.7.7-stdcpp-link-fix.patch
Patch3: gtkmathview-0.7.7-link-backends-fix.patch
Patch4: gtkmathview-0.8.0-alt-fix-linking.patch
Patch5: gtkmathview-0.8.0-alt-fix-pkgconfig.patch
Patch6: libgtkmathview-0.8.0-debian-gcc43-fix.patch
Patch7: gtkmathview-0.8.0-alt-DSO.patch
Patch8: gtkmathview-0.8.0-alt-gcc4.7.patch
Patch9: gtkmathview-0.8.0-alt-glibc-2.16.patch

%define gtk_ver 2.2.4
%define libxml2_ver 2.5.6

BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: libxml2-devel >= %libxml2_ver


BuildRequires: gcc-c++ libpopt-devel t1lib-devel xsltproc

%description
GtkMathView is a C++ rendering engine for MathML documents. 
It provides an interactive view that can be used for browsing 
and editing MathML markup.

%package -n %name-devel
Summary: Libraries, headers, and support files needed for using gtkmathview.
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Requires: libgtk+2-devel >= %gtk_ver
Requires: libxml2-devel >= %libxml2_ver

%description -n %name-devel
Libraries, headers, and support files needed for using gtkmathview.

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q -n %real_name-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p2
%patch8 -p2
%patch9 -p2

%build
%add_optflags -fpermissive
autoreconf -fisv
%configure --with-t1lib=yes
	
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name-1.0

%files -f %name-1.0.lang
%_bindir/mathmlsvg
%_bindir/mathmlps
%_libdir/*.so.*
%_datadir/%real_name
%_man1dir/mathml*
%dir %_sysconfdir/%real_name
%config(noreplace) %_sysconfdir/%real_name/*.xml
%doc AUTHORS ChangeLog NEWS README

%files -n %name-devel
%_includedir/%real_name/*
%_libdir/*.so
%exclude %_libdir/*.a
%_libdir/pkgconfig/*.pc
%doc AUTHORS README BUGS CONTRIBUTORS NEWS ANNOUNCEMENT TODO


%changelog
