%define api_version 2.4
%define rname gtkmm
%define major 2.24

Name: libgtkmm2
Version: %major.3
Release: alt2

Summary: A C++ interface for GTK2 (a GUI library for X)
License: LGPL
Group: System/Libraries
Url: http://gtkmm.sourceforge.net/
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

#Source: ftp://ftp.gnome.org/pub/gnome/sources/%rname/%major/%rname-%version.tar.xz
Source: %rname-2.24.2.tar.xz

Provides: %rname = %version

BuildRequires: mm-common >= 0.9.6
BuildRequires: gcc-c++ libgtk+2-devel >= 2.24.0 libpangomm-devel libatkmm-devel

%description
Gtkmm provides a C++ interface to the GTK+ GUI library. gtkmm2 wraps GTK+ 2.
Highlights include typesafe callbacks, widgets extensible via inheritance
and a comprehensive set of widget classes that can be freely combined to
quickly create complex user interfaces.

%package devel
Summary: Headers for developing programs that will use %name
Group: Development/C++
Requires: %name = %version-%release
Provides: %rname-devel = %version

%description devel
This package contains the static libraries and header files needed for
developing gtkmm applications.

%package doc
Summary: Documentation for developing with %name
Group: Development/C++
BuildArch: noarch

%description doc
This package contains the documentation for
developing gtkmm applications.

%package demos
Summary: Demos for developing programs that will use %name
Group: Development/C++
BuildArch: noarch
Requires: %name-devel = %version-%release

%description demos
The %name-demos package contains source code of demo programs for %name.

%prep
#%%setup -q -n %rname-%version
%setup -q -n %rname-2.24.2

%build
mm-common-prepare
%autoreconf
%configure \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot gtkmm_docdir=%_docdir/%rname-%api_version install

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%_includedir/gdkmm-%api_version
%_includedir/%rname-%api_version
%_libdir/*.so
%_libdir/gdkmm-%api_version
%_libdir/%rname-%api_version
%_pkgconfigdir/*.pc

%files doc
%_docdir/%rname-%api_version
%_datadir/devhelp/books/%rname-%api_version

#%files demos
#%_datadir/%rname-%api_version

%changelog
