%define _name gtksourceview
%define ver_major 2.10
%def_disable static
%def_disable gtk_doc
%def_disable introspection

Name: lib%{_name}
Version: %ver_major.5
Release: alt2.1

Summary: GtkSourceView text widget library
License: LGPLv2+
Group: System/Libraries
Url: http://www.gnome.org
Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

Source: %gnome_ftp/%_name/%ver_major/%_name-%version.tar.bz2
Source1: %name-%ver_major.map
Patch: %name-2.9.4-alt-symver.patch

Provides: %{name}2 = %version-%release
Obsoletes: %{name}2 < %version-%release

# From configure.ac
%define intltool_ver 0.35
%define gtk_ver 2.12.0
%define libxml2_ver 2.5.0

BuildPreReq: rpm-build-gnome

# From configure.ac
BuildPreReq: intltool >= %intltool_ver
BuildPreReq: gnome-common
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: libxml2-devel >= %libxml2_ver
BuildPreReq: libGConf-devel
BuildPreReq: gtk-doc >= 1.0

BuildRequires: gcc-c++ perl-XML-Parser zlib-devel libgio-devel cvs
BuildRequires: gobject-introspection-devel
%{?_enable_introspection:BuildRequires: libgtk+2-gir-devel}

%description
GtkSourceView is a text widget that extends the standard gtk+ 2.x text
widget GtkTextView. It improves GtkTextView by implementing syntax
highlighting and other features typical of a source editor.

This package contains shared GtkSourceView library.

%package devel
Summary: Files to compile applications that use GtkSourceView
Group: Development/GNOME and GTK+
Requires: %name = %version-%release
Provides: %{name}2-devel = %version-%release
Obsoletes: %{name}2-devel < %version-%release


%description devel
This package contains the files required to develop applications against
the GtkSourceView library.

%package devel-doc
Summary: Development documentation for %_name
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
GtkSourceView is a text widget that extends the standard gtk+ 2.x text
widget GtkTextView. It improves GtkTextView by implementing syntax
highlighting and other features typical of a source editor.

This package provides development documentation for %_name.

%package gir
Summary: GObject introspection data for the GtkSourceView library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the GtkSourceView library

%package gir-devel
Summary: GObject introspection devel data for the GtkSourceView library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the GtkSourceView library


%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q -n %_name-%version
install -p -m644 %SOURCE1 gtksourceview/libgtksourceview.map
%patch

#rm -f gtksourceview/GtkSource-2.0.gir

%build
%autoreconf
%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable introspection}

%make_build

#%check
#%%make check

%install
%make_install DESTDIR=%buildroot install

%find_lang %_name-2.0

%files -f %_name-2.0.lang
%_libdir/*.so.*
%_datadir/%_name-2.0
%doc AUTHORS ChangeLog NEWS README

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%doc HACKING MAINTAINERS

%files devel-doc
%_gtk_docdir/*

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/*

%files gir-devel
%_datadir/gir-1.0/*
%endif


%changelog
