%define oldname libgtop2
%define ver_major 2.28
%def_disable static
%def_with examples
%def_enable introspection

Name: libgtop
Version: %ver_major.5
Release: alt1

Summary: LibGTop library
License: GPLv2+
Group: System/Libraries
Url: ftp://ftp.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Obsoletes: %oldname < 2.14.2
Provides: %oldname = %version-%release

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Patch2: %name-2.0.0-texinfo.patch
Patch4: %name-2.9.90-alt-examples_makefile.patch
Patch5: %name-2.0.1-alt-as.patch

# From configure.in
%define glib_ver 2.6.0

BuildPreReq: rpm-build-gnome
BuildPreReq: intltool >= 0.35
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: gtk-doc >= 1.4
BuildRequires: libICE-devel libX11-devel perl-XML-Parser
%{?_enable_static:BuildPreReq: glibc-devel-static}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.6.7}

%description
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

On Linux systems, this information is taken directly from the /proc
filesystem while on other systems a server is used to read that
information from other /dev/kmem, among others.

%package examples
Group: Development/GNOME and GTK+
Summary: The LibGTop samples
Obsoletes: %oldname-examples < 2.14.2
Provides: %oldname-examples = %version-%release
Requires: %name = %version-%release

%description examples
This package contains some example of using %name library

%package devel
Summary: Development files for %name
Group: Development/GNOME and GTK+
Obsoletes: %oldname-devel < 2.14.2
Provides: %oldname-devel = %version-%release
Requires: %name = %version-%release

%description devel
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

Install this package if you wish to develop applications that access
information on system statistics such as CPU and memory usage.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name-devel < %version-%release
BuildArch: noarch

%description devel-doc
LibGTop is a library that fetches information about the running
system such as CPU and memory useage, active processes and more.

This package contains development documentation for the library.

%package devel-static
Summary: Static libraries for %name
Group: Development/GNOME and GTK+
Obsoletes: %oldname-devel-static < 2.14.2
Provides: %oldname-devel-static = %version-%release
Requires: %name-devel = %version-%release

%description devel-static
This package contains static libraries for development with %name.

%package gir
Summary: GObject introspection data for the LibGTop library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the LibGTop library

%package gir-devel
Summary: GObject introspection devel data for the LibGTop library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the LibGTop library


%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup -q
%patch2 -p1
%patch4 -p1
%patch5 -p1

rm -rf doc/*.info

%build
gtkdocize
%autoreconf
%configure \
	%{subst_enable static} \
	--enable-gtk-doc \
	%{?_with_examples:--with-libgtop-examples} \

%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name-2.0

%files -f %name-2.0.lang
%_libdir/*.so.*
%doc AUTHORS NEWS README

%if_with examples
%files examples
%dir %_libdir/%name
%_libdir/%name/*
%endif

%files devel
%_includedir/%name-2.0
%_libdir/*.so
%_pkgconfigdir/*
%_infodir/*.info*

%files devel-doc
%_gtk_docdir/*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/GTop-2.0.typelib

%files gir-devel
%_datadir/gir-1.0/GTop-2.0.gir
%endif

%changelog
