%define _name gupnp-igd
%define api_ver 1.0
%def_disable static
%def_disable gtk_doc
%def_enable introspection
%def_enable python

Name: libgupnp-igd
Version: 0.2.2
Release: alt1

Summary: A library to handle UPnP IGD port mapping
Group: System/Libraries
License: LGPLv2+
Url: http://www.gupnp.org/

Source: http://www.gupnp.org/sources/%_name/%_name-%version.tar.xz

BuildPreReq: libgupnp-devel >= 0.13.2
BuildRequires: glib2-devel >= 2.14 gtk-doc
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgupnp-gir-devel}
%{?_enable_python:BuildRequires: python-module-pygobject-devel python-module-pygtk-devel}

%description
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%name is a library to handle UPnP IGD port mapping.

%package devel
Summary: Development files and libraries for gUPnP-IGD
Group: Development/C
Requires: %name = %version-%release

%description devel
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%name is a library to handle UPnP IGD port mapping.
This package provides files for development with gUPnP-IGD.

%package devel-doc
Summary: Development documentaion for gUPnP-IGD
Group: Development/C
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%name is a library to handle UPnP IGD port mapping.
This package provides development documentations for gUPnP-IGD.

%package gir
Summary: GObject introspection data for the gUPnP-IGD library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the gUPnP-IGD library

%package gir-devel
Summary: GObject introspection devel data for the gUPnP-IGD library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the gUPnP-IGD library

%package -n python-module-%name
Summary: Python bindings for gUPnP-IGD
Group: Development/Python
Requires: %name = %version-%release

%description -n python-module-%name
gUPnP is an object-oriented open source framework for creating UPnP
devices and control points, written in C using GObject and libsoup.
The gUPnP API is intended to be easy to use, efficient and flexible.

%name is a library to handle UPnP IGD port mapping.
This package provides Python bindings for gUPnP-IGD

%prep
%setup -q -n %_name-%version

%build
%autoreconf
%configure --disable-static \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable python}

%make_build

%install
%make DESTDIR=%buildroot install

%check
#%make check

%files
%_libdir/*.so.*
%doc AUTHORS README ChangeLog

%files devel
%_libdir/pkgconfig/*
%_libdir/*.so
%_includedir/*

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/GUPnPIgd-%api_ver.typelib

%files gir-devel
%_girdir/GUPnPIgd-%api_ver.gir
%endif

%files -n python-module-%name
%python_sitelibdir/gupnp/*

%exclude %python_sitelibdir/gupnp/*.la

%changelog
