%define ver_major 3.8
%define api_ver 3.0
%def_disable static
%def_enable introspection

Name: libgweather
Version: %ver_major.4
Release: alt0.M70P.1
Summary: A library for weather information

Group: System/Libraries
License: GPLv3
Url: https://live.gnome.org/LibGWeather
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

# From configure.in
%define gtk_ver 2.91.7
%define glib_ver 2.35.1
%define intltool_ver 0.40.0
%define soup_ver 2.34
%define gir_ver 0.9.5

Requires: %name-data = %version-%release

BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libsoup-devel >= %soup_ver
BuildPreReq: intltool >= %intltool_ver
BuildPreReq: xsltproc
BuildPreReq: rpm-build-gnome gtk-doc
BuildRequires: libxml2-devel perl-XML-Parser xml-utils gzip
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= %gir_ver libgtk+3-gir-devel}

%description
libgweather is a library to access weather information from online
services for numerous locations.

%package data
Summary: Locations data for %name
Group: System/Libraries
BuildArch: noarch

%description data
libgweather is a library to access weather information from online
services for numerous locations.

This package contains locations data for %name

%package devel
Summary: Development files for %name
Group: Development/GNOME and GTK+
# libgweather used to be part of gnome-applets, and
# gnome-applets-devel only had the libgweather-devel parts in it
Obsoletes: gnome-applets-gweather-devel < %version
Provides: gnome-applets-gweather-devel = %version
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-doc
The %name-devel-doc package contains documentation for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name library

%package gir-devel
Summary: GObject introspection devel data for the %name library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the %name library

%prep
%setup -q

%build
%configure \
    %{subst_enable static} \
    --enable-locations-compression

%make_build

#cd po
#make %name.pot
#for p in *.po; do
#  msgmerge -U $p %name.pot
#done
#make
#cd ..

%install
%make_install DESTDIR=%buildroot install

%find_lang --output=%name.lang %name-%api_ver

# do the %%lang tag for the localized xml files
find %buildroot -name Locations.*.xml.gz | sed 's:'"%buildroot"'::
s:\(.*\)/Locations\.\([^.]*\)\.xml.gz:%lang(\2) \1/Locations.\2.xml.gz:' > %name-data.lang

%check
%make check

%files -f %name.lang
%_libdir/*.so.*
%_datadir/glib-2.0/schemas/org.gnome.GWeather.enums.xml
%_datadir/glib-2.0/schemas/org.gnome.GWeather.gschema.xml
%doc AUTHORS NEWS README

%files data -f %name-data.lang
%dir %_datadir/libgweather
%_datadir/libgweather/Locations.xml.gz
%_datadir/libgweather/locations.dtd
%_iconsdir/gnome/*/*/*

%files devel
%_includedir/%name-%api_ver
%_libdir/*.so
%_pkgconfigdir/*

%files devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_libdir/girepository-1.0/GWeather-3.0.typelib

%files gir-devel
%_datadir/gir-1.0/GWeather-3.0.gir
%endif

%changelog
