%define origname gwenhywfar

Name:     libgwenhywfar
Version:  4.3.3
Release:  alt1

Summary:  A multi-platform helper library for other libraries
Group:    System/Libraries
License:  LGPLv2+
URL:      http://www2.aquamaniac.de/sites/download/packages.php

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:   %origname-%version.tar.bz2
Source1:  %name.watch
Patch1:   %name-pthread.patch

BuildRequires: gcc-c++ glibc-devel graphviz libcom_err-devel 
BuildRequires: libgnutls-devel libssl-devel tzdata
BuildRequires: libqt4-devel libgtk+2-devel
BuildRequires: zlib-devel libgcrypt-devel ncurses-devel
BuildRequires: ca-certificates

Requires: ca-certificates

%description
This is Gwenhywfar, a multi-platform helper library for networking and
security applications and libraries. It is heavily used by libchipcard
www.libchipcard.de and OpenHBCI-TNG (The Next Generation)
www.openhbci.de.

Check http://www.freesource.info/wiki/Altlinux/Policy/TLS
for ALT Linux TLS/SSL policy

%package  gtk2
Summary:  Gwenhywfar support for GTK+
Group:    System/Libraries
Requires: %name = %version-%release

%description gtk2
Gwenhywfar support for GTK+

%package  qt4
Summary:  Gwenhywfar support for Qt4
Group:    System/Libraries
Requires: %name = %version-%release

%description qt4
Gwenhywfar support for Qt4

%package  devel
Summary:  Gwenhywfar development kit
Group:    Development/C
Requires: %name = %version-%release
Requires: %name-gtk2 = %version-%release
Requires: %name-qt4  = %version-%release

%description devel
This package contains gwenhywfar-config and header files for writing and
compiling programs using Gwenhywfar.

%prep
%setup -q -n %origname-%version
%patch1 -p2

%build
%autoreconf
%configure \
	--disable-static \
	--with-openssl-libs=%_libdir \
	--with-guis="qt4 gtk2" \
	--with-qt4-libs="%_libdir" 

%make_build

%install
%makeinstall_std
%find_lang %origname

# Use system-wide ca-certificates
rm -f %buildroot%_datadir/gwenhywfar/ca-bundle.crt
ln -s %_datadir/ca-certificates/ca-bundle.crt %buildroot%_datadir/gwenhywfar/ca-bundle.crt

%files -f %origname.lang
%doc AUTHORS README ChangeLog TODO NEWS
%_bindir/gct-tool
%_bindir/gsa
%_libdir/*.so.*
%exclude %_libdir/libgwengui-gtk2.so.*
%exclude %_libdir/libgwengui-qt4.so.*
%_libdir/%origname/
%_datadir/gwenhywfar/ca-bundle.crt
%_datadir/gwenhywfar/dialogs/*.dlg

%files gtk2
%_libdir/libgwengui-gtk2.so.*

%files qt4
%_libdir/libgwengui-qt4.so.*

%files devel
%_bindir/%origname-config
%_bindir/xmlmerge
%_bindir/mklistdoc
%_bindir/typemaker
%_bindir/typemaker2
%_libdir/*.so
%_includedir/gwenhywfar4/
%_pkgconfigdir/*
%_datadir/%origname/typemaker2/*
%_datadir/aclocal/gwenhywfar.m4

%changelog
