Name: libidn
Version: 1.27
Release: alt1

Summary: Internationalized Domain Name support library
Group: System/Libraries
License: LGPLv3+/GPLv2+ and GPLv3+ and GFDL
Url: http://www.gnu.org/software/%name/
# ftp://ftp.gnu.org/gnu/%name/%name-%version.tar.gz
Source: %name-%version.tar

%def_with emacs
%{?!_without_emacs:BuildRequires: emacs-devel emacs-nox}

%description
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

%package devel
Group: Development/C
Summary: Development files for the %name library
Requires: %name = %version-%release

%description devel
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

This package includes headers and other development files necessary
for developing programs which use the GNU Libidn library.

%package devel-doc
Summary: Development documentation for the %name library
Group: Development/C
License: GFDL
Requires: %name-devel = %version-%release
BuildArch: noarch

%description devel-doc
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

This package contains %name development documentation.

%package -n emacs-%name
Summary: GNU Emacs %name support files
Group: Development/Other
License: GPLv3+
BuildArch: noarch

%description -n emacs-%name
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

This package includes %name support files for GNU Emacs.

%prep
%setup
iconv -f iso88591 -t utf8 -o doc/libidn.utf8 doc/libidn.info
mv doc/libidn.utf8 doc/libidn.info

%build
%configure \
	--disable-rpath \
	--disable-static \
	--disable-silent-rules \
	--with-packager="%packager" \
	--with-packager-version="%release" \
	--with-packager-bug-reports="http://bugs.altlinux.org" \
	#
# get rid of RPATH
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std
rm %buildroot%_infodir/*.png
%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir/reference/html
install -pm644 doc/*.html doc/*.pdf %buildroot%docdir/
install -pm644 AUTHORS COPYING FAQ NEWS README THANKS %buildroot%docdir/
install -pm644 doc/reference/*.pdf %buildroot%docdir/reference/
install -pm644 doc/reference/html/* %buildroot%docdir/reference/html/

%find_lang %name
%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%make_build -k check

%files -f %name.lang
%_libdir/*.so.*
%_bindir/idn
%_man1dir/*
%dir %docdir
%docdir/[ACFNRT]*

%files devel
%_libdir/*.so
%_includedir/*.h
%_pkgconfigdir/*.pc
%_man3dir/*
%_infodir/*

%files devel-doc
%dir %docdir
%docdir/*.html
%docdir/*.pdf
%docdir/reference/

%if_with emacs
%files -n emacs-%name
%_emacslispdir/*
%endif #emacs

%changelog
