Name: libjpeg-turbo
Version: 1.2.1
Release: alt1
Epoch: 2

Summary: A SIMD-accelerated library for manipulating JPEG image format files
License: wxWidgets
Group: System/Libraries
Url: http://sourceforge.net/projects/%name/

# http://download.sourceforge.net/%name/%name-%version.tar.gz
Source: %name-%version.tar
Source2: http://jpegclub.org/jpegexiforient.c
Source3: exifautotran
Source4: jpeginfo.c

Patch1: libjpeg-6b-suse-int32.patch
Patch2: libjpeg-turbo-1.2.0-fedora-noinst.patch
Patch3: libjpeg-turbo-alt-rdjpgcom-i18n.patch
Patch4: libjpeg-turbo-alt-versioning.patch
Patch5: libjpeg-turbo-alt-libturbojpeg.patch
Patch6: libjpeg-turbo-alt-warnings.patch

%def_enable static

# for jpgtest.cxx
BuildRequires: gcc-c++

%ifarch %ix86 x86_64
BuildRequires: nasm
%endif

%package -n libjpeg
Summary: A library for manipulating JPEG image format files
Group: System/Libraries

%package -n libjpeg-devel
Summary: Development tools for programs which will use the libjpeg library
Group: Development/C
Requires: libjpeg = %epoch:%version-%release
%ifnarch %ix86
Provides: libjpeg-mmx-devel
%endif

%package -n libjpeg-devel-static
Summary: Static libjpeg library
Group: Development/C
Requires: libjpeg-devel = %epoch:%version-%release
%ifnarch %ix86
Provides: libjpeg-mmx-devel-static
%endif

%package -n libjpeg-utils
Summary: Programs for manipulating JPEG format image files
Group: Graphics
Requires: libjpeg = %epoch:%version-%release

%package -n libturbojpeg
Summary: A turbojpeg library
Group: System/Libraries
Requires: libjpeg = %epoch:%version-%release

%package -n libturbojpeg-devel
Summary: Development files for the turbojpeg library
Group: Development/C
Requires: libturbojpeg = %epoch:%version-%release

%description
libjpeg-turbo is a derivative of libjpeg which uses SIMD instructions
(MMX, SSE2, etc.) to accelerate baseline JPEG compression and
decompression on x86 and x86-64 systems.  On such systems, libjpeg-turbo
is generally 2-4x as fast as the unmodified version of libjpeg, all else
being equal.

%description -n libjpeg
This package contains a shared library of functions for loading,
manipulating and saving JPEG format image files.

%description -n libjpeg-devel
This package includes development files necessary for developing
programs which will manipulate JPEG files using the jpeg library.

%description -n libjpeg-devel-static
This package includes static library necessary for developing statically
linked programs which will manipulate JPEG files using the jpeg library.

%description -n libjpeg-utils
This package contains simple client programs for accessing the
libjpeg functions.  Libjpeg client programs include cjpeg, djpeg,
jpegtran, rdjpgcom and wrjpgcom.  Cjpeg compresses an image file
into JPEG format.  Djpeg decompresses a JPEG file into a regular
image file.  Jpegtran can perform various useful transformations
on JPEG files.  Rdjpgcom displays any text comments included in
a JPEG file.  Wrjpgcom inserts text comments into a JPEG file.

%description -n libturbojpeg
This package contains a turbojpeg shared library.

%description -n libturbojpeg-devel
This package contains development files for the turbojpeg library.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

install -pm644 %_sourcedir/{jpegexiforient,jpeginfo}.c .
install -pm755 %_sourcedir/exifautotran .

# restrict list of global symbols exported by the library.
sed -n 's/^EXTERN([^()]*)[[:space:]]*\([^[:space:]]\+\).*/\1/p' jpeglib.h \
	> libjpeg.sym
sed -n 's/^EXTERN([^()]*)[[:space:]]*\([^[:space:]]\+\).*/\1/p' jpegint.h \
	| egrep -v '^(jinit_|jzero_far)' >> libjpeg.sym
# extra symbols required by packages
cat >> libjpeg.sym <<'EOF'
jinit_c_master_control
jpeg_std_message_table
EOF
sort -u -o libjpeg.sym{,}

%build
%autoreconf
%configure --enable-shared %{subst_enable static}
%make_build
make jpegexiforient
%__cc $CPPFLAGS -D_GNU_SOURCE jpeginfo.c -L.libs -ljpeg -o jpeginfo
bzip2 -9fk libjpeg.txt structure.txt usage.txt

%check
LD_LIBRARY_PATH=%buildroot%_libdir make -k test
LD_LIBRARY_PATH=%buildroot%_libdir ./jpeginfo *.jpg >/dev/null

%install
mkdir -p %buildroot{%_bindir,%_libdir,%_includedir,%_man1dir}
%makeinstall_std
install -pm755 exifautotran jpegexiforient jpeginfo %buildroot%_bindir/
# do not package unwanted libturbojpeg files
find %buildroot -name 'libturbojpeg.*a' -delete

%define docdir %_docdir/%name
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -pm644 README* ChangeLog.txt change.log example.c \
	coderules.txt libjpeg.txt.bz2 structure.txt.bz2 usage.txt.bz2 wizard.txt \
	%buildroot%docdir/

%files -n libjpeg
%_libdir/libjpeg.so.*
%dir %docdir
%docdir/[CLR]*

%files -n libjpeg-utils
%_bindir/*
%_mandir/man?/*

%files -n libjpeg-devel
%_libdir/libjpeg.so
%_includedir/j*
%dir %docdir
%docdir/[^CLR]*

%if_enabled static
%files -n libjpeg-devel-static
%_libdir/libjpeg.a
%endif #static

%files -n libturbojpeg
%_libdir/libturbojpeg.so.*

%files -n libturbojpeg-devel
%_libdir/libturbojpeg.so
%_includedir/turbojpeg.h

%changelog
