%define _name json-glib
%define ver_major 0.16
%define api_ver 1.0
%def_disable gtk_doc
%def_disable static
%def_enable introspection

Name: lib%_name
Version: %ver_major.2
Release: alt1

Summary: Library for JavaScript Object Notation format
Group: System/Libraries
License: LGPLv2+
Url: http://live.gnome.org/JsonGlib

Source: ftp://ftp.gnome.org/pub/GNOME/sources/%_name/%ver_major/%_name-%version.tar.xz

%define glib_ver 2.31.0
%define gi_ver 0.10.5
%{?_enable_static:BuildPreReq: glibc-devel-static}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gi_ver}
BuildRequires: glib2-devel >= %glib_ver gtk-doc

%description
%_name is a library providing serialization and deserialization support
for the JavaScript Object Notation (JSON) format.

%package devel
Summary: Development files for %_name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for the JSON-GLib library
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the JSON-GLib library

%package gir-devel
Summary: GObject introspection devel data for the JSON-GLib library
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the JSON-GLib library

%prep
%setup -q -n %_name-%version

%build
%configure \
    %{subst_enable static} \
    %{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --output=%_name.lang %_name-%api_ver

%check
%make check

%files -f %_name.lang
%_libdir/*.so.*
%doc NEWS

%files devel
%_libdir/*.so
%_libdir/pkgconfig/*
%_includedir/*
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files gir
%_typelibdir/*

%files gir-devel
%_girdir/*
%endif

%changelog
